/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.FailureIsAnOption;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import junit.framework.AssertionFailedError;

public class JsLexerTest
extends CajaTestCase {
    public final void testLexer() throws Exception {
        StringBuilder output = new StringBuilder();
        JsLexer t = new JsLexer(this.fromResource("lexertest1.js"));
        while (t.hasNext()) {
            Token<JsTokenType> tok = t.next();
            output.append(((JsTokenType)tok.type).toString().substring(0, 4) + " [" + tok.text + "]: " + tok.pos + "\n");
        }
        String golden = this.fromResource("lexergolden1.txt").toString();
        JsLexerTest.assertEquals((String)golden, (String)output.toString());
    }

    public final void testLexer2() throws Exception {
        StringBuilder output = new StringBuilder();
        JsLexer t = new JsLexer(this.fromResource("lexertest2.js"));
        while (t.hasNext()) {
            Token<JsTokenType> tok = t.next();
            output.append(((JsTokenType)tok.type).toString().substring(0, 4) + " [" + tok.text + "]: " + tok.pos + "\n");
        }
        String golden = this.fromResource("lexergolden2.txt").toString();
        JsLexerTest.assertEquals((String)golden, (String)output.toString());
    }

    public final void testRegexLiterals() {
        JsLexer lexer = this.createLexer("foo.replace(/[A-Z]/g, '#')");
        this.assertNext(lexer, JsTokenType.WORD, "foo");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ".");
        this.assertNext(lexer, JsTokenType.WORD, "replace");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.REGEXP, "/[A-Z]/g");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ",");
        this.assertNext(lexer, JsTokenType.STRING, "'#'");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertEmpty(lexer);
    }

    public final void testSimpleExpression() {
        JsLexer lexer = this.createLexer("while (foo) { 1; }");
        this.assertNext(lexer, JsTokenType.KEYWORD, "while");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.WORD, "foo");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "{");
        this.assertNext(lexer, JsTokenType.INTEGER, "1");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ";");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "}");
        this.assertEmpty(lexer);
    }

    public final void testQuasiExpressionSingle() {
        JsLexer lexer = this.createLexer("@foo * 1;", true);
        this.assertNext(lexer, JsTokenType.WORD, "@foo");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "*");
        this.assertNext(lexer, JsTokenType.INTEGER, "1");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ";");
        this.assertEmpty(lexer);
    }

    public final void testQuasiExpressionStar() {
        JsLexer lexer = this.createLexer("@foo* * 1;", true);
        this.assertNext(lexer, JsTokenType.WORD, "@foo*");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "*");
        this.assertNext(lexer, JsTokenType.INTEGER, "1");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ";");
        this.assertEmpty(lexer);
    }

    public final void testQuasiExpressionPlus() {
        JsLexer lexer = this.createLexer("@foo+ + 1;", true);
        this.assertNext(lexer, JsTokenType.WORD, "@foo+");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "+");
        this.assertNext(lexer, JsTokenType.INTEGER, "1");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ";");
        this.assertEmpty(lexer);
    }

    public final void testQuasiExpressionSingleParens() {
        JsLexer lexer = this.createLexer("(@foo)", true);
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.WORD, "@foo");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertEmpty(lexer);
    }

    public final void testQuasiExpressionStarParens() {
        JsLexer lexer = this.createLexer("(@foo*)", true);
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.WORD, "@foo*");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertEmpty(lexer);
    }

    public final void testQuasiExpressionPlusParens() {
        JsLexer lexer = this.createLexer("(@foo+)", true);
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.WORD, "@foo+");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertEmpty(lexer);
    }

    public final void testDoubleDot() {
        JsLexer lexer = this.createLexer("a == = function () {..} ... .. . .... foo", true);
        this.assertNext(lexer, JsTokenType.WORD, "a");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "==");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "=");
        this.assertNext(lexer, JsTokenType.KEYWORD, "function");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "{");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "..");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "}");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "...");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "..");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ".");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "...");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ".");
        this.assertNext(lexer, JsTokenType.WORD, "foo");
        this.assertEmpty(lexer);
    }

    public final void testNumberDotWord() {
        JsLexer lexer = this.createLexer("0..toString()", false);
        this.assertNext(lexer, JsTokenType.FLOAT, "0.");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ".");
        this.assertNext(lexer, JsTokenType.WORD, "toString");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "(");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, ")");
        this.assertEmpty(lexer);
    }

    public final void testByteOrderMarkersAtBeginning() {
        JsLexer lexer = this.createLexer("\ufeffvar foo", false);
        this.assertNext(lexer, JsTokenType.KEYWORD, "var");
        this.assertNext(lexer, JsTokenType.WORD, "foo");
        this.assertEmpty(lexer);
    }

    public final void testByteOrderMarkersBetweenTokens() {
        JsLexer lexer = this.createLexer("1.\ufeff3", false);
        this.assertNext(lexer, JsTokenType.FLOAT, "1.");
        this.assertNext(lexer, JsTokenType.INTEGER, "3");
        this.assertEmpty(lexer);
    }

    public final void testByteOrderMarkersInStrings() {
        JsLexer lexer = this.createLexer("'\ufeff'", false);
        this.assertNext(lexer, JsTokenType.STRING, "'\ufeff'");
        this.assertEmpty(lexer);
    }

    public final void testEllipsisAndNumber() {
        JsLexer lexer = this.createLexer("...0x01", false);
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "...");
        this.assertNext(lexer, JsTokenType.INTEGER, "0x01");
        this.assertEmpty(lexer);
    }

    public final void testEmphaticallyDecremented() {
        JsLexer lexer = this.createLexer("i---j", false);
        this.assertNext(lexer, JsTokenType.WORD, "i");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "--");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "-");
        this.assertNext(lexer, JsTokenType.WORD, "j");
        this.assertEmpty(lexer);
    }

    public final void testIsRegexpFollowingWord() {
        JsLexer lexer = this.createLexer("min / max /*/**/", false);
        this.assertNext(lexer, JsTokenType.WORD, "min");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "/");
        this.assertNext(lexer, JsTokenType.WORD, "max");
        this.assertNext(lexer, JsTokenType.COMMENT, "/*/**/");
        this.assertEmpty(lexer);
        lexer = this.createLexer("in / max /*/**/", false);
        this.assertNext(lexer, JsTokenType.KEYWORD, "in");
        this.assertNext(lexer, JsTokenType.REGEXP, "/ max /");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "*");
        this.assertNext(lexer, JsTokenType.COMMENT, "/**/");
        this.assertEmpty(lexer);
    }

    public final void testRegexpFollowingVoid() {
        JsLexer lexer = this.createLexer("void /./", false);
        this.assertNext(lexer, JsTokenType.KEYWORD, "void");
        this.assertNext(lexer, JsTokenType.REGEXP, "/./");
        this.assertEmpty(lexer);
    }

    @FailureIsAnOption
    public final void testRegexpFollowingPreincrement() {
        JsLexer lexer = this.createLexer("x = ++/x/m", false);
        this.assertNext(lexer, JsTokenType.WORD, "x");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "=");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "++");
        this.assertNext(lexer, JsTokenType.REGEXP, "/x/m");
        this.assertEmpty(lexer);
    }

    public final void testRegexpFollowingPostincrement() {
        JsLexer lexer = this.createLexer("x++/y/m", false);
        this.assertNext(lexer, JsTokenType.WORD, "x");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "++");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "/");
        this.assertNext(lexer, JsTokenType.WORD, "y");
        this.assertNext(lexer, JsTokenType.PUNCTUATION, "/");
        this.assertNext(lexer, JsTokenType.WORD, "m");
        this.assertEmpty(lexer);
    }

    private JsLexer createLexer(String src) {
        return this.createLexer(src, false);
    }

    private JsLexer createLexer(String src, boolean isQuasiliteral) {
        return new JsLexer(this.fromString(src), isQuasiliteral);
    }

    private void assertNext(JsLexer lexer, JsTokenType type, String text) {
        Token<JsTokenType> tok = null;
        try {
            tok = lexer.next();
        }
        catch (ParseException e) {
            throw (AssertionFailedError)new AssertionFailedError(e.getMessage()).initCause((Throwable)e);
        }
        JsLexerTest.assertEquals((Object)type, tok.type);
        JsLexerTest.assertEquals((String)("was '" + tok.text + "', expected '" + text + "'"), (String)text, (String)tok.text);
    }

    public void assertEmpty(JsLexer lexer) {
        try {
            JsLexerTest.assertFalse((boolean)lexer.hasNext());
        }
        catch (ParseException e) {
            JsLexerTest.fail((String)e.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        InputSource input = new InputSource(URI.create("file:///proc/self/fd/0"));
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        JsLexer t = new JsLexer(CharProducer.Factory.create((Reader)in, input));
        while (t.hasNext()) {
            Token<JsTokenType> tok = t.next();
            System.out.append(((JsTokenType)tok.type).toString().substring(0, 4) + " [" + tok.text + "]: " + tok.pos + "\n");
        }
    }
}

