/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.tools.jmx.Manager;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;

public class GuiceServletContextListener
implements ServletContextListener {
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";
    public static final String MODULES_ATTRIBUTE = "guice-modules";
    public static final String INJECTOR_NAME = Injector.class.getName();
    private static final String SYSTEM_PROPERTIES = "system.properties";
    private boolean jmxInitialized = false;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        this.setSystemProperties(context);
        String moduleNames = context.getInitParameter(MODULES_ATTRIBUTE);
        LinkedList modules = Lists.newLinkedList();
        if (moduleNames != null) {
            for (String moduleName : StringUtils.split((String)moduleNames, (char)':')) {
                try {
                    moduleName = moduleName.trim();
                    if (moduleName.length() <= 0) continue;
                    modules.add((Module)Class.forName(moduleName).newInstance());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules);
        context.setAttribute(INJECTOR_ATTRIBUTE, (Object)injector);
        try {
            if (!this.jmxInitialized) {
                Manager.manage((String)"ShindigGuiceContext", (Injector)injector);
                this.jmxInitialized = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }

    private void setSystemProperties(ServletContext context) {
        String systemProperties = context.getInitParameter(SYSTEM_PROPERTIES);
        String key = null;
        String value = null;
        if (systemProperties != null && systemProperties.trim().length() > 0) {
            for (String aProperty : StringUtils.split((String)systemProperties, (char)'\n')) {
                String[] keyAndvalue = StringUtils.split((String)aProperty.trim(), (String)"=", (int)2);
                if (keyAndvalue.length != 2) continue;
                key = keyAndvalue[0];
                value = keyAndvalue[1];
                if (key == null || key.trim().length() <= 0 || value == null || value.trim().length() <= 0) continue;
                System.setProperty(key, value);
            }
        }
    }
}

