/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.wcm.publication.Result;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PaginatedResultIterator
extends PageList {
    protected Result result;

    public PaginatedResultIterator(int pageSize) {
        super(pageSize);
    }

    public PaginatedResultIterator(Result result, int pageSize) {
        super(pageSize);
        this.result = result;
        this.setAvailablePage((int)result.getNumTotal());
        this.currentListPage_ = null;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null) {
            return;
        }
        this.currentListPage_ = new ArrayList();
        WCMComposer composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
        this.result.getFiltersDescriber().put("filter-limit", "" + this.getPageSize());
        this.result.getFiltersDescriber().put("filter-offset", "" + this.getPageSize() * (page - 1));
        this.result.getFiltersDescriber().put("filter-total-number", "" + this.result.getNumTotal());
        this.result = composer.getPaginatedContents(this.result.getNodeLocationDescriber(), this.result.getFiltersDescriber(), WCMCoreUtils.getUserSessionProvider());
        this.currentListPage_ = this.result.getNodes();
        this.currentPage_ = page;
    }

    public int getTotalPages() {
        return this.getAvailablePage();
    }

    public int getNodesPerPage() {
        return this.getPageSize();
    }

    public long getTotalNodes() {
        return this.result.getNumTotal();
    }

    public List getCurrentPageData() throws Exception {
        return this.currentPage();
    }

    public List getPage(int page) throws Exception {
        if (page < 1 || page > this.availablePage_) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.populateCurrentPage(page);
        return this.currentListPage_;
    }

    public void changePage(int page) throws Exception {
        this.populateCurrentPage(page);
    }

    public List getAll() throws Exception {
        throw new UnsupportedOperationException();
    }
}

