/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.statetransfer.DistributedStateTransferManagerImpl;
import org.infinispan.statetransfer.DummyInvalidationStateTransferManagerImpl;
import org.infinispan.statetransfer.ReplicatedStateTransferManagerImpl;
import org.infinispan.statetransfer.StateTransferManager;

@DefaultFactoryFor(classes={StateTransferManager.class})
public class StateTransferManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.configuration.getCacheMode().isClustered()) {
            return null;
        }
        if (this.configuration.getCacheMode().isDistributed()) {
            return componentType.cast(new DistributedStateTransferManagerImpl());
        }
        if (this.configuration.getCacheMode().isReplicated()) {
            return componentType.cast(new ReplicatedStateTransferManagerImpl());
        }
        if (this.configuration.getCacheMode().isInvalidation()) {
            return componentType.cast(new DummyInvalidationStateTransferManagerImpl());
        }
        return null;
    }
}

