/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.diff;

import org.suigeneris.jrcs.diff.DiffAlgorithm;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.myers.MyersDiff;
import org.suigeneris.jrcs.util.ToString;

public class Diff
extends ToString {
    public static final String NL = System.getProperty("line.separator");
    public static final String RCS_EOL = "\n";
    protected final Object[] orig;
    protected DiffAlgorithm algorithm;

    public Diff(Object[] original) {
        this(original, null);
    }

    public Diff(Object[] original, DiffAlgorithm algorithm) {
        if (original == null) {
            throw new IllegalArgumentException("no original text");
        }
        this.orig = original;
        this.algorithm = algorithm != null ? algorithm : this.defaultAlgorithm();
    }

    protected DiffAlgorithm defaultAlgorithm() {
        return new MyersDiff();
    }

    public Revision diff(Object[] rev) throws DifferentiationFailedException {
        if (this.orig.length == 0 && rev.length == 0) {
            return new Revision();
        }
        return this.algorithm.diff(this.orig, rev);
    }

    public static Revision diff(Object[] orig, Object[] rev, DiffAlgorithm algorithm) throws DifferentiationFailedException {
        if (orig == null || rev == null) {
            throw new IllegalArgumentException("orig or reve is null");
        }
        return new Diff(orig, algorithm).diff(rev);
    }

    public static Revision diff(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("orig is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("rev is null");
        }
        return Diff.diff(orig, rev, null);
    }

    public static boolean compare(Object[] orig, Object[] rev) {
        if (orig.length != rev.length) {
            return false;
        }
        for (int i = 0; i < orig.length; ++i) {
            if (orig[i].equals(rev[i])) continue;
            return false;
        }
        return true;
    }

    public static String arrayToString(Object[] o) {
        return Diff.arrayToString(o, NL);
    }
}

