/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg.context.impl;

import java.lang.reflect.Method;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.ParameterConstraintMappingContext;
import org.hibernate.validator.cfg.context.ReturnValueConstraintMappingContext;
import org.hibernate.validator.cfg.context.impl.ConfiguredConstraint;
import org.hibernate.validator.cfg.context.impl.ConstraintMappingContext;
import org.hibernate.validator.cfg.context.impl.ConstraintMappingContextImplBase;
import org.hibernate.validator.cfg.context.impl.ReturnValueConstraintMappingContextImpl;
import org.hibernate.validator.metadata.location.MethodConstraintLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterConstraintMappingContextImpl
extends ConstraintMappingContextImplBase
implements ParameterConstraintMappingContext {
    private final Method method;
    private final int parameterIndex;

    public ParameterConstraintMappingContextImpl(Class<?> beanClass, Method method, int parameterIndex, ConstraintMappingContext mapping) {
        super(beanClass, mapping);
        if (parameterIndex < 0 || parameterIndex >= method.getParameterTypes().length) {
            throw new IllegalArgumentException("A valid parameter index has to be specified for method '" + method.getName() + "'");
        }
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public ParameterConstraintMappingContext constraint(ConstraintDef<?, ?> definition) {
        this.mapping.addMethodConstraintConfig(ConfiguredConstraint.forParameter(definition, this.method, this.parameterIndex));
        return this;
    }

    @Override
    public ParameterConstraintMappingContext valid() {
        this.mapping.addMethodCascadeConfig(new MethodConstraintLocation(this.method, this.parameterIndex));
        return this;
    }

    @Override
    public ParameterConstraintMappingContext parameter(int index) {
        return new ParameterConstraintMappingContextImpl(this.beanClass, this.method, index, this.mapping);
    }

    @Override
    public ReturnValueConstraintMappingContext returnValue() {
        return new ReturnValueConstraintMappingContextImpl(this.beanClass, this.method, this.mapping);
    }
}

