/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.PathPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class PathValueData
extends AbstractValueData {
    protected QPath value;

    protected PathValueData(int orderNumber, QPath value) {
        super(orderNumber);
        this.value = value;
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof PathValueData) {
            return ((PathValueData)another).value.equals(this.value);
        }
        return false;
    }

    protected byte[] spoolInternalValue() {
        try {
            return this.value.getAsString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    public String toString() {
        return this.value.getAsString();
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new PathPersistedValueData(orderNumber, this.value);
    }

    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    protected String getString() {
        return this.value.getAsString();
    }

    protected InternalQName getName() throws ValueFormatException {
        if (this.value.getDepth() == 0 && !this.value.isAbsolute()) {
            QPathEntry entry = this.value.getEntries()[0];
            return new InternalQName(entry.getNamespace(), entry.getName());
        }
        throw new ValueFormatException("Can't conver to InternalQName. Wrong value type.");
    }

    protected QPath getPath() {
        return this.value;
    }
}

