/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class BridgeMethodResolver {
    static /* synthetic */ Class class$java$lang$Object;

    public static Method findBridgedMethod(Method bridgeMethod) {
        Assert.notNull(bridgeMethod, "Method must not be null");
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < methods.length; ++i) {
            Method candidateMethod = methods[i];
            if (!BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod)) continue;
            candidateMethods.add(candidateMethod);
        }
        Method result = candidateMethods.size() == 1 ? (Method)candidateMethods.get(0) : BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod);
        if (result == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + bridgeMethod + "'");
        }
        return result;
    }

    private static Method searchCandidates(List candidateMethods, Method bridgeMethod) {
        Map typeParameterMap = GenericTypeResolver.getTypeVariableMap(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < candidateMethods.size(); ++i) {
            Method candidateMethod = (Method)candidateMethods.get(i);
            if (!BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, typeParameterMap)) continue;
            return candidateMethod;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && !candidateMethod.equals(bridgeMethod) && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterTypes().length == bridgeMethod.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Map typeVariableMap) {
        if (BridgeMethodResolver.isResolvedTypeMatch(candidateMethod, bridgeMethod, typeVariableMap)) {
            return true;
        }
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null && BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, typeVariableMap);
    }

    private static Method findGenericDeclaration(Method bridgeMethod) {
        Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(superclass)) {
            Method method = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (method != null && !method.isBridge()) {
                return method;
            }
            superclass = superclass.getSuperclass();
        }
        Class[] interfaces = ClassUtils.getAllInterfacesForClass(bridgeMethod.getDeclaringClass());
        for (int i = 0; i < interfaces.length; ++i) {
            Class anInterface = interfaces[i];
            Method method = BridgeMethodResolver.searchForMatch(anInterface, bridgeMethod);
            if (method == null || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Map typeVariableMap) {
        Class<?>[] candidateParameters;
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        if (genericParameters.length != (candidateParameters = candidateMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < genericParameters.length; ++i) {
            Type rawType;
            Type genericParameter = genericParameters[i];
            Class<?> candidateParameter = candidateParameters[i];
            if (candidateParameter.isArray() && (rawType = GenericTypeResolver.getRawType(genericParameter, typeVariableMap)) instanceof GenericArrayType) {
                if (candidateParameter.getComponentType().equals(GenericTypeResolver.resolveType(((GenericArrayType)rawType).getGenericComponentType(), typeVariableMap))) break;
                return false;
            }
            if (candidateParameter.equals(GenericTypeResolver.resolveType(genericParameter, typeVariableMap))) continue;
            return false;
        }
        return true;
    }

    private static Method searchForMatch(Class type, Method bridgeMethod) {
        return ReflectionUtils.findMethod(type, bridgeMethod.getName(), bridgeMethod.getParameterTypes());
    }
}

