/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.configuration.jaxb2;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class SystemPropertiesSubstitutionConverter {
    private static Logger log = Logger.getLogger(SystemPropertiesSubstitutionConverter.class.getName());

    public static String substituteSystemProperty(String input) {
        String output = SystemPropertiesSubstitutionConverter.substituteVariable(input);
        log.fine("Substituting value from configuration with System properties - input=" + input + ", output=" + output);
        return output;
    }

    public static String printValue(String input) {
        return input;
    }

    private static String substituteVariable(String val) {
        if (val == null) {
            return val;
        }
        String retval = val;
        while (retval.contains("${")) {
            String prev = retval;
            if (!(retval = SystemPropertiesSubstitutionConverter._substituteVar(retval)).equals(prev)) continue;
            break;
        }
        return retval;
    }

    private static String _substituteVar(String val) {
        int start_index = val.indexOf("${");
        if (start_index == -1) {
            return val;
        }
        int end_index = val.indexOf("}", start_index + 2);
        if (end_index == -1) {
            throw new IllegalArgumentException("missing \"}\" in " + val);
        }
        String tmp = SystemPropertiesSubstitutionConverter.getProperty(val.substring(start_index + 2, end_index));
        if (tmp == null) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, start_index));
        sb.append(tmp);
        sb.append(val.substring(end_index + 1));
        return sb.toString();
    }

    private static String getProperty(String s) {
        String retval = null;
        int index = s.indexOf(":");
        if (index >= 0) {
            String var = s.substring(0, index);
            String default_val = s.substring(index + 1);
            if (default_val != null && default_val.length() > 0) {
                default_val = default_val.trim();
            }
            retval = SystemPropertiesSubstitutionConverter._getProperty(var, default_val);
        } else {
            String var = s;
            retval = SystemPropertiesSubstitutionConverter._getProperty(var, null);
        }
        return retval;
    }

    private static String _getProperty(String var, String default_value) {
        if (var == null) {
            return null;
        }
        List<String> list = SystemPropertiesSubstitutionConverter.parseCommaDelimitedStrings(var);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<String>(1);
            list.add(var);
        }
        String retval = null;
        for (String prop : list) {
            try {
                retval = System.getProperty(prop);
                if (retval == null) continue;
                return retval;
            }
            catch (Throwable e) {
            }
        }
        return default_value;
    }

    private static List<String> parseCommaDelimitedStrings(String l) {
        return SystemPropertiesSubstitutionConverter.parseStringList(l, ",");
    }

    private static List<String> parseStringList(String l, String separator) {
        LinkedList<String> tmp = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(l, separator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t.trim());
        }
        return tmp;
    }
}

