/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.JobExecutionContext;

public class UpdateUserProfileJob
extends MultiTenancyJob {
    private static Log LOG = ExoLogger.getLogger(UpdateUserProfileJob.class);

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return UpdateUserProfileTask.class;
    }

    public class UpdateUserProfileTask
    extends MultiTenancyJob.MultiTenancyTask {
        public UpdateUserProfileTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)UpdateUserProfileJob.this, context, repoName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
            try {
                ExoContainer exoContainer = CommonUtils.getExoContainer((JobExecutionContext)this.context);
                ForumService forumService = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
                ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                String name = this.context.getJobDetail().getKey().getName();
                JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
                JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", this.context.getJobDetail().getJobClass());
                RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
                repositoryService.setCurrentRepositoryName(this.context.getJobDetail().getJobDataMap().getString(Utils.CACHE_REPO_NAME));
                forumService.updateUserProfileInfo(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"\n\nNumber of deleted posts, topics updated to Forum statistics and user's profile");
                }
                schedulerService.removeJob(info);
            }
            catch (Exception e) {
                LOG.trace((Object)("User profile could not updated: \n" + e.getCause()));
            }
            finally {
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            }
        }
    }
}

