/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import juzu.Scope;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.ScopeController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Container {
    static final ThreadLocal<Container> boot = new ThreadLocal();
    private List<ReadFileSystem<?>> fileSystems = new ArrayList();
    final Set<Scope> scopes;
    final ScopeController scopeController;

    protected Container(ScopeController scopeController, Set<Scope> scopes) {
        this.scopes = scopes;
        this.scopeController = scopeController;
    }

    public abstract BeanManager getManager();

    public abstract ClassLoader getClassLoader();

    public void addFileSystem(ReadFileSystem<?> fileSystem) {
        this.fileSystems.add(fileSystem);
    }

    protected abstract void doStart(List<ReadFileSystem<?>> var1) throws Exception;

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        boot.set(this);
        try {
            this.doStart(this.fileSystems);
        }
        finally {
            boot.set(null);
        }
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

