/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.betwixt.digester.RuleSupport;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeRule
extends RuleSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$AttributeRule == null ? (class$org$apache$commons$betwixt$digester$AttributeRule = AttributeRule.class$("org.apache.commons.betwixt.digester.AttributeRule")) : class$org$apache$commons$betwixt$digester$AttributeRule));
    private ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private Class beanClass;
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$AttributeRule;

    public void begin(String name, String namespace, Attributes attributes) throws SAXException {
        AttributeDescriptor descriptor = new AttributeDescriptor();
        String nameAttributeValue = attributes.getValue("name");
        if (!XMLUtils.isWellFormedXMLName(nameAttributeValue)) {
            throw new SAXException("'" + nameAttributeValue + "' would not be a well formed xml attribute name.");
        }
        String qName = nameAttributeValue;
        descriptor.setLocalName(nameAttributeValue);
        String uri = attributes.getValue("uri");
        if (uri != null) {
            descriptor.setURI(uri);
            String prefix = this.getXMLIntrospector().getConfiguration().getPrefixMapper().getPrefix(uri);
            qName = prefix + ":" + nameAttributeValue;
        }
        descriptor.setQualifiedName(qName);
        String propertyName = attributes.getValue("property");
        descriptor.setPropertyName(propertyName);
        descriptor.setPropertyType(this.loadClass(attributes.getValue("type")));
        if (propertyName != null && propertyName.length() > 0) {
            this.configureDescriptor(descriptor);
        } else {
            String value = attributes.getValue("value");
            if (value != null) {
                descriptor.setTextExpression(new ConstantExpression(value));
            }
        }
        Object top = this.digester.peek();
        if (!(top instanceof ElementDescriptor)) {
            throw new SAXException("Invalid use of <attribute>. It should be nested inside an <element> element");
        }
        ElementDescriptor parent = (ElementDescriptor)top;
        parent.addAttributeDescriptor(descriptor);
        this.digester.push((Object)descriptor);
    }

    public void end(String name, String namespace) {
        AttributeDescriptor descriptor = (AttributeDescriptor)this.digester.pop();
        ElementDescriptor parent = (ElementDescriptor)this.digester.peek();
        if (this.getXMLIntrospector().getConfiguration().getAttributeSuppressionStrategy().suppress(descriptor)) {
            parent.removeAttributeDescriptor(descriptor);
        }
    }

    protected Class loadClass(String name) {
        if (name != null) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void configureDescriptor(AttributeDescriptor attributeDescriptor) {
        block4: {
            Class beanClass = this.getBeanClass();
            if (beanClass != null) {
                String name = attributeDescriptor.getPropertyName();
                try {
                    BeanInfo beanInfo = this.getXMLIntrospector().getConfiguration().ignoreAllBeanInfo() ? Introspector.getBeanInfo(beanClass, 3) : Introspector.getBeanInfo(beanClass);
                    PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                    if (descriptors == null) break block4;
                    int size = descriptors.length;
                    for (int i = 0; i < size; ++i) {
                        PropertyDescriptor descriptor = descriptors[i];
                        if (!name.equals(descriptor.getName())) continue;
                        this.configureProperty(attributeDescriptor, descriptor);
                        this.getProcessedPropertyNameSet().add(name);
                        break;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Caught introspection exception", (Throwable)e);
                }
            }
        }
    }

    private void configureProperty(AttributeDescriptor attributeDescriptor, PropertyDescriptor propertyDescriptor) {
        Class<?> type = propertyDescriptor.getPropertyType();
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (readMethod == null) {
            log.trace((Object)"No read method");
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read method=" + readMethod));
        }
        if (this.getXMLIntrospector().isLoopType(type)) {
            log.warn((Object)("Using loop type for an attribute. Type = " + type.getName() + " attribute: " + attributeDescriptor.getQualifiedName()));
        }
        log.trace((Object)"Standard property");
        attributeDescriptor.setTextExpression(new MethodExpression(readMethod));
        if (writeMethod != null) {
            attributeDescriptor.setUpdater(new MethodUpdater(writeMethod));
        }
        attributeDescriptor.setPropertyName(propertyDescriptor.getName());
        attributeDescriptor.setPropertyType(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

