/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.FileInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class ResolverLocalFilesystem
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResolverLocalFilesystem.class);
    private static int FILE_URI_LENGTH = "file:/".length();

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        try {
            URI uriNew = ResolverLocalFilesystem.getNewURI(uri.getNodeValue(), baseURI);
            String fileName = ResolverLocalFilesystem.translateUriToFilename(uriNew.toString());
            FileInputStream inputStream = new FileInputStream(fileName);
            XMLSignatureInput result = new XMLSignatureInput(inputStream);
            result.setSourceURI(uriNew.toString());
            return result;
        }
        catch (Exception e) {
            throw new ResourceResolverException("generic.EmptyMessage", e, uri, baseURI);
        }
    }

    private static String translateUriToFilename(String uri) {
        String subStr = uri.substring(FILE_URI_LENGTH);
        if (subStr.indexOf("%20") > -1) {
            int offset = 0;
            int index = 0;
            StringBuilder temp = new StringBuilder(subStr.length());
            do {
                if ((index = subStr.indexOf("%20", offset)) == -1) {
                    temp.append(subStr.substring(offset));
                    continue;
                }
                temp.append(subStr.substring(offset, index));
                temp.append(' ');
                offset = index + 3;
            } while (index != -1);
            subStr = temp.toString();
        }
        if (subStr.charAt(1) == ':') {
            return subStr;
        }
        return "/" + subStr;
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        block8: {
            if (uri == null) {
                return false;
            }
            String uriNodeValue = uri.getNodeValue();
            if (uriNodeValue.equals("") || uriNodeValue.charAt(0) == '#' || uriNodeValue.startsWith("http:")) {
                return false;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("I was asked whether I can resolve " + uriNodeValue));
                }
                if (uriNodeValue.startsWith("file:") || baseURI.startsWith("file:")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("I state that I can resolve " + uriNodeValue));
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"But I can't");
        }
        return false;
    }

    private static URI getNewURI(String uri, String baseURI) throws URISyntaxException {
        URI newUri = null;
        newUri = baseURI == null || "".equals(baseURI) ? new URI(uri) : new URI(baseURI).resolve(uri);
        if (newUri.getFragment() != null) {
            URI uriNewNoFrag = new URI(newUri.getScheme(), newUri.getSchemeSpecificPart(), null);
            return uriNewNoFrag;
        }
        return newUri;
    }
}

