/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.web.login.LoginServlet;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

public class RememberMeFilter
extends AbstractFilter {
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    private void doFilter(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req.getRemoteUser() == null) {
            ExoContainer container;
            CookieTokenService tokenservice;
            Credentials credentials;
            String token = LoginServlet.getRememberMeTokenCookie(req);
            if (token != null && (credentials = (tokenservice = (CookieTokenService)(container = this.getContainer()).getComponentInstanceOfType(CookieTokenService.class)).validateToken(token, false)) != null) {
                ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                try {
                    servletContainer.login(req, resp, credentials);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (req.getRemoteUser() == null) {
                Cookie cookie = new Cookie("rememberme", "");
                cookie.setPath(req.getContextPath());
                cookie.setMaxAge(0);
                resp.addCookie(cookie);
            }
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void destroy() {
    }
}

