/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.piff;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TfrfBox
extends AbstractFullBox {
    public int fragmentCount;
    public List<Entry> entries = new ArrayList<Entry>();

    public TfrfBox() {
        super("uuid");
    }

    @Override
    public byte[] getUserType() {
        return new byte[]{-44, -128, 126, -14, -54, 57, 70, -107, -114, 84, 38, -53, -98, 70, -89, -97};
    }

    @Override
    protected long getContentSize() {
        return 1 + this.fragmentCount * (this.getVersion() == 1 ? 16 : 8);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.fragmentCount = in.readUInt8();
        for (int i = 0; i < this.fragmentCount; ++i) {
            Entry entry = new Entry();
            if (this.getVersion() == 1) {
                entry.fragmentAbsoluteTime = in.readUInt64();
                entry.fragmentAbsoluteDuration = in.readUInt64();
            } else {
                entry.fragmentAbsoluteTime = in.readUInt32();
                entry.fragmentAbsoluteDuration = in.readUInt32();
            }
            this.entries.add(entry);
        }
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.fragmentCount);
        for (Entry entry : this.entries) {
            if (this.getVersion() == 1) {
                os.writeUInt64(entry.fragmentAbsoluteTime);
                os.writeUInt64(entry.fragmentAbsoluteDuration);
                continue;
            }
            os.writeUInt32(entry.fragmentAbsoluteTime);
            os.writeUInt32(entry.fragmentAbsoluteDuration);
        }
    }

    public long getFragmentCount() {
        return this.fragmentCount;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TfrfBox");
        sb.append("{fragmentCount=").append(this.fragmentCount);
        sb.append(", entries=").append(this.entries);
        sb.append('}');
        return sb.toString();
    }

    public class Entry {
        long fragmentAbsoluteTime;
        long fragmentAbsoluteDuration;

        public long getFragmentAbsoluteTime() {
            return this.fragmentAbsoluteTime;
        }

        public long getFragmentAbsoluteDuration() {
            return this.fragmentAbsoluteDuration;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry");
            sb.append("{fragmentAbsoluteTime=").append(this.fragmentAbsoluteTime);
            sb.append(", fragmentAbsoluteDuration=").append(this.fragmentAbsoluteDuration);
            sb.append('}');
            return sb.toString();
        }
    }
}

