/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserProfileEventListenerImpl
extends UserProfileEventListener {
    public void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = idm.getOrCreateIdentity("organization", userProfile.getUserName(), true);
        Profile profile = identity.getProfile();
        String uGender = null;
        String uPosition = null;
        if (userProfile != null) {
            uGender = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]);
            uPosition = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);
        }
        String pGender = (String)profile.getProperty("gender");
        String pPosition = (String)profile.getProperty("position");
        boolean hasUpdated = false;
        if (uGender != null && !uGender.equals(pGender)) {
            profile.setProperty("gender", uGender);
            hasUpdated = true;
        }
        if (uPosition != null && !uPosition.equals(pPosition)) {
            profile.setProperty("position", uPosition);
            hasUpdated = true;
        }
        if (hasUpdated) {
            IdentityStorage storage = (IdentityStorage)container.getComponentInstanceOfType(IdentityStorage.class);
            storage.updateProfile(profile);
        }
        RequestLifeCycle.end();
    }
}

