/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.ChannelException;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class LargeStateTransferTest
extends ChannelTestBase {
    JChannel provider;
    JChannel requester;
    Promise<Integer> p = new Promise();
    long start;
    long stop;
    static final int SIZE_1 = 100000;
    static final int SIZE_2 = 1000000;
    static final int SIZE_3 = 5000000;
    static final int SIZE_4 = 10000000;

    public LargeStateTransferTest(String name) {
        super(name);
    }

    @Override
    public boolean useBlocking() {
        return true;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
        this.provider = this.createChannel("A");
        this.requester = this.createChannel("A");
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.provider != null) {
            this.provider.close();
        }
        if (this.requester != null) {
            this.requester.close();
        }
        super.tearDown();
    }

    public void testStateTransfer1() throws ChannelException {
        this._testStateTransfer(100000);
    }

    public void testStateTransfer2() throws ChannelException {
        this._testStateTransfer(1000000);
    }

    public void testStateTransfer3() throws ChannelException {
        this._testStateTransfer(5000000);
    }

    public void testStateTransfer4() throws ChannelException {
        this._testStateTransfer(10000000);
    }

    public void _testStateTransfer(int size) throws ChannelException {
        this.provider.setReceiver(new Provider(size));
        this.provider.connect("X");
        this.p.reset();
        this.requester.setReceiver(new Requester(this.p));
        this.requester.connect("X");
        LargeStateTransferTest.log("requesting state of " + size + " bytes");
        this.start = System.currentTimeMillis();
        this.requester.getState(null, 20000L);
        Integer result = this.p.getResult(10000L);
        this.stop = System.currentTimeMillis();
        LargeStateTransferTest.log("result=" + result + " bytes (in " + (this.stop - this.start) + "ms)");
        LargeStateTransferTest.assertNotNull((Object)result);
        LargeStateTransferTest.assertEquals((Object)result, (Object)new Integer(size));
    }

    static void log(String msg) {
        System.out.println(Thread.currentThread() + " -- " + msg);
    }

    public static Test suite() {
        return new TestSuite(LargeStateTransferTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LargeStateTransferTest.suite());
    }

    private static class Requester
    extends ExtendedReceiverAdapter {
        Promise<Integer> p;

        public Requester(Promise<Integer> p) {
            this.p = p;
        }

        @Override
        public byte[] getState() {
            throw new UnsupportedOperationException("not implemented by requester");
        }

        @Override
        public void setState(byte[] state) {
            this.p.setResult(new Integer(state.length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void setState(InputStream istream) {
            ObjectInputStream ois = null;
            int size = 0;
            try {
                ois = new ObjectInputStream(istream);
                size = ois.readInt();
                byte[] stateReceived = new byte[size];
                ois.read(stateReceived);
            }
            catch (IOException e) {
                Util.close(ois);
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
            }
            Util.close(ois);
            this.p.setResult(new Integer(size));
        }
    }

    private static class Provider
    extends ExtendedReceiverAdapter {
        byte[] state;

        public Provider(int size) {
            this.state = new byte[size];
        }

        @Override
        public byte[] getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                oos.writeInt(this.state.length);
                oos.write(this.state);
            }
            catch (IOException iOException) {
            }
            finally {
                Util.close(ostream);
            }
        }

        @Override
        public void setState(byte[] state) {
            throw new UnsupportedOperationException("not implemented by provider");
        }
    }
}

