/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.portal.controller.resource.Resource;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.script.ScriptGraph;

public class BaseScriptResource<R extends Resource<R>>
extends Resource<R> {
    ScriptGraph graph;
    private final Map<QualifiedName, String> parameters;
    private final Map<Locale, Map<QualifiedName, String>> parametersMap;
    private final Map<QualifiedName, String> minParameters;
    private final Map<Locale, Map<QualifiedName, String>> minParametersMap;

    BaseScriptResource(ScriptGraph graph, ResourceId id) {
        super(id);
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(WebAppController.HANDLER_PARAM, "script");
        parameters.put(ResourceRequestHandler.RESOURCE_QN, id.getName());
        parameters.put(ResourceRequestHandler.SCOPE_QN, id.getScope().name());
        parameters.put(ResourceRequestHandler.COMPRESS_QN, "");
        parameters.put(ResourceRequestHandler.VERSION_QN, ResourceRequestHandler.VERSION);
        parameters.put(ResourceRequestHandler.LANG_QN, "");
        HashMap<QualifiedName, String> minifiedParameters = new HashMap<QualifiedName, String>(parameters);
        minifiedParameters.put(ResourceRequestHandler.COMPRESS_QN, "min");
        this.parameters = parameters;
        this.minParameters = minifiedParameters;
        this.graph = graph;
        this.parametersMap = new HashMap<Locale, Map<QualifiedName, String>>();
        this.minParametersMap = new HashMap<Locale, Map<QualifiedName, String>>();
    }

    public Map<QualifiedName, String> getParameters(boolean minified, Locale locale) {
        Map<Locale, Map<QualifiedName, String>> map = minified ? this.minParametersMap : this.parametersMap;
        Locale current = locale;
        while (current != null) {
            Map<QualifiedName, String> ret = map.get(locale);
            if (ret != null) {
                return ret;
            }
            current = I18N.getParent((Locale)current);
        }
        return minified ? this.minParameters : this.parameters;
    }

    public void addSupportedLocale(Locale locale) {
        if (!this.parametersMap.containsKey(locale)) {
            HashMap<QualifiedName, String> localizedParameters = new HashMap<QualifiedName, String>(this.parameters);
            localizedParameters.put(ResourceRequestHandler.LANG_QN, I18N.toTagIdentifier((Locale)locale));
            this.parametersMap.put(locale, localizedParameters);
            HashMap<QualifiedName, String> localizedMinParameters = new HashMap<QualifiedName, String>(this.minParameters);
            localizedMinParameters.put(ResourceRequestHandler.LANG_QN, I18N.toTagIdentifier((Locale)locale));
            this.minParametersMap.put(locale, localizedMinParameters);
        }
    }
}

