/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.ISO8601;

public abstract class BaseValue
implements Value {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private static final short STATE_UNDEFINED = 0;
    private static final short STATE_VALUE_CONSUMED = 1;
    private static final short STATE_STREAM_CONSUMED = 2;
    private short state = 0;
    protected final int type;
    protected InputStream stream = null;

    BaseValue(int type) {
        this.type = type;
    }

    protected void setStreamConsumed() throws IllegalStateException {
        if (this.state == 1) {
            throw new IllegalStateException("non-stream value has already been consumed");
        }
        this.state = (short)2;
    }

    protected void setValueConsumed() throws IllegalStateException {
        if (this.state == 2) {
            throw new IllegalStateException("stream value has already been consumed");
        }
        this.state = 1;
    }

    protected abstract String getInternalString() throws ValueFormatException, RepositoryException;

    public int getType() {
        return this.type;
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        Calendar cal = ISO8601.parse(this.getInternalString());
        if (cal == null) {
            throw new ValueFormatException("not a valid date format");
        }
        return cal;
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        try {
            return Long.parseLong(this.getInternalString());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("conversion to long failed", (Throwable)e);
        }
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        return Boolean.valueOf(this.getInternalString());
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        try {
            return Double.parseDouble(this.getInternalString());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("conversion to double failed", (Throwable)e);
        }
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        this.setStreamConsumed();
        if (this.stream != null) {
            return this.stream;
        }
        try {
            this.stream = new ByteArrayInputStream(this.getInternalString().getBytes(DEFAULT_ENCODING));
            return this.stream;
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("UTF-8 not supported on this platform", (Throwable)e);
        }
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        return this.getInternalString();
    }
}

