/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;

public class CacheKeyBuilder {
    private static final int NUM_LEGACY_PARAMS = 9;
    private static final String DEFAULT_KEY_VALUE = "0";
    private static final char KEY_SEPARATOR = ':';
    private Object[] legacyParams;
    private SortedMap<String, Object> paramMap = Maps.newTreeMap();

    public CacheKeyBuilder() {
        this.legacyParams = new Object[9];
    }

    private String getValueOrDefault(Object value) {
        if (value == null) {
            return DEFAULT_KEY_VALUE;
        }
        return String.valueOf(value);
    }

    public CacheKeyBuilder setLegacyParam(int index, Object value) {
        this.legacyParams[index] = value;
        return this;
    }

    public CacheKeyBuilder setParam(String name, Object value) {
        if (value != null) {
            this.paramMap.put(name, String.valueOf(value));
        }
        return this;
    }

    public String build() {
        StringBuilder keyBuilder = new StringBuilder(2 * String.valueOf(this.legacyParams[0]).length());
        this.appendLegacyKeys(keyBuilder);
        if (!this.paramMap.isEmpty()) {
            for (Map.Entry<String, Object> mapEntry : this.paramMap.entrySet()) {
                keyBuilder.append(':');
                keyBuilder.append(String.format("%s=%s", mapEntry.getKey(), mapEntry.getValue()));
            }
        }
        return keyBuilder.toString();
    }

    private void appendLegacyKeys(StringBuilder key) {
        boolean first = true;
        for (Object legacyParam : this.legacyParams) {
            if (!first) {
                key.append(':');
            } else {
                first = false;
            }
            key.append(this.getValueOrDefault(legacyParam));
        }
    }
}

