/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.servlet.GuiceServletContextListener;
import org.exoplatform.portal.gadget.core.GateInContainerConfigLoader;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class GateInGuiceServletContextListener
extends GuiceServletContextListener {
    private static ThreadLocal<GateInContainerConfigLoader> currentLoader = new ThreadLocal();
    private final Logger log = LoggerFactory.getLogger(GateInGuiceServletContextListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        final ServletContext scontext = event.getServletContext();
        GateInContainerConfigLoader loader = new GateInContainerConfigLoader(){

            @Override
            public String loadContentAsString(String path, String encoding) throws IOException {
                InputStream is;
                if ('/' != path.charAt(0)) {
                    path = '/' + path;
                }
                return (is = scontext.getResourceAsStream(path)) != null ? IOUtils.toString((InputStream)is, (String)encoding) : null;
            }

            @Override
            public InputStream loadResourceAsStream(String path) {
                if ('/' != path.charAt(0)) {
                    path = '/' + path;
                }
                return scontext.getResourceAsStream(path);
            }
        };
        currentLoader.set(loader);
        try {
            super.contextInitialized(event);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            currentLoader.set(null);
        }
    }

    public static GateInContainerConfigLoader getCurrentLoader() {
        return currentLoader.get();
    }
}

