/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.acl.Group;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;

public class SecurityUtil {
    private static Logger log = Logger.getLogger(SecurityUtil.class);
    private static String LEGACY_JAAS_CONTEXT_ROOT = "java:/jaas/";

    public static String unprefixSecurityDomain(String securityDomain) {
        String result = null;
        if (securityDomain != null) {
            result = securityDomain.startsWith("java:jboss/jaas/") ? securityDomain.substring("java:jboss/jaas/".length()) : (securityDomain.startsWith("java:jboss/jbsx/") ? securityDomain.substring("java:jboss/jbsx/".length()) : (securityDomain.startsWith(LEGACY_JAAS_CONTEXT_ROOT) ? securityDomain.substring(LEGACY_JAAS_CONTEXT_ROOT.length()) : securityDomain));
        }
        return result;
    }

    public static Group getSubjectRoles(Subject theSubject) {
        if (theSubject == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:Subject is null");
        }
        Set<Group> subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator<Group> iter = subjectGroups.iterator();
        Group roles = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roles = grp;
        }
        return roles;
    }

    public static ApplicationPolicy getApplicationPolicy(String domainName) {
        return SecurityConfiguration.getApplicationPolicy(domainName);
    }

    public static AuthenticationManager getAuthenticationManager(String securityDomain, String baseContext) {
        AuthenticationManager am;
        block2: {
            String securityMgrURL = "/securityMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith(baseContext) ? securityDomain + securityMgrURL : baseContext + "/" + securityDomain + securityMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuthenticationManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining AuthenticationManager", (Throwable)e);
            }
        }
        return am;
    }

    public static AuthorizationManager getAuthorizationManager(String securityDomain, String baseContext) {
        AuthorizationManager am;
        block2: {
            String authorizationMgrURL = "/authorizationMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith(baseContext) ? securityDomain + authorizationMgrURL : baseContext + "/" + securityDomain + authorizationMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuthorizationManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining AuthorizationMgr", (Throwable)e);
            }
        }
        return am;
    }

    public static AuditManager getAuditManager(String securityDomain, String baseContext) {
        AuditManager am;
        block2: {
            String auditMgrURL = "/auditMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith(baseContext) ? securityDomain + auditMgrURL : baseContext + "/" + securityDomain + auditMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuditManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining AuditMgr", (Throwable)e);
            }
        }
        return am;
    }

    public static IdentityTrustManager getIdentityTrustManager(String securityDomain, String baseContext) {
        IdentityTrustManager am;
        block2: {
            String identityTrustMgrURL = "/identityTrustMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith(baseContext) ? securityDomain + identityTrustMgrURL : baseContext + "/" + securityDomain + identityTrustMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (IdentityTrustManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining IdentityTrustMgr", (Throwable)e);
            }
        }
        return am;
    }

    public static MappingManager getMappingManager(String securityDomain, String baseContext) {
        MappingManager am;
        block2: {
            String mappingManagerURL = "/mappingMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith(baseContext) ? securityDomain + mappingManagerURL : baseContext + "/" + securityDomain + mappingManagerURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (MappingManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining IdentityTrustMgr", (Throwable)e);
            }
        }
        return am;
    }

    public static PolicyRegistration getPolicyRegistration() {
        PolicyRegistration registration;
        block2: {
            String lookupURL = "java:/policyRegistration";
            registration = null;
            try {
                InitialContext ic = new InitialContext();
                registration = (PolicyRegistration)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Error in obtaining IdentityTrustMgr", (Throwable)e);
            }
        }
        return registration;
    }
}

