/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui;

import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.gatein.common.util.UUIDGenerator;

public class CSRFTokenUtil {
    public static final String CSRF_TOKEN = "gtn:csrf";
    private static Log log = ExoLogger.getExoLogger(CSRFTokenUtil.class);
    private static final UUIDGenerator generator = new UUIDGenerator();

    public static boolean check() throws Exception {
        HttpServletRequest request = CSRFTokenUtil.getRequest();
        if (request != null) {
            String sessionToken = CSRFTokenUtil.getToken();
            String reqToken = request.getParameter(CSRF_TOKEN);
            return reqToken != null && reqToken.equals(sessionToken);
        }
        log.warn((Object)"No HttpServletRequest found, can't check CSRF");
        return false;
    }

    public static String getToken() throws Exception {
        HttpServletRequest request = CSRFTokenUtil.getRequest();
        if (request != null) {
            HttpSession session = request.getSession();
            String token = (String)session.getAttribute(CSRF_TOKEN);
            if (token == null) {
                token = generator.generateKey();
                session.setAttribute(CSRF_TOKEN, (Object)token);
            }
            return token;
        }
        log.warn((Object)"No HttpServletRequest found, can't generate CSRF token");
        return null;
    }

    private static HttpServletRequest getRequest() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context != null && context.getRequest() instanceof PortletRequest) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        if (context != null) {
            return (HttpServletRequest)context.getRequest();
        }
        log.warn((Object)"Can't find portal context");
        return null;
    }
}

