/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.portlet.PortletConfig;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.resources.PortletConfigRegistry;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

public abstract class WebuiRequestContext
extends RequestContext {
    protected UIApplication uiApplication_;
    protected String sessionId_;
    protected ResourceBundle appRes_;
    private StateManager stateManager_;
    private boolean responseComplete_ = false;
    private boolean processRender_ = false;
    private Set<UIComponent> uicomponentToUpdateByAjax;

    public WebuiRequestContext(Application app) {
        super(app);
    }

    protected WebuiRequestContext(RequestContext parentAppRequestContext, Application app_) {
        super(parentAppRequestContext, app_);
    }

    public String getSessionId() {
        return this.sessionId_;
    }

    protected void setSessionId(String id) {
        this.sessionId_ = id;
    }

    public UIApplication getUIApplication() {
        return this.uiApplication_;
    }

    public void setUIApplication(UIApplication uiApplication) throws Exception {
        this.uiApplication_ = uiApplication;
        this.appRes_ = null;
    }

    public ResourceBundle getApplicationResourceBundle() {
        if (this.appRes_ == null) {
            try {
                this.appRes_ = this.findApplicationResourceBundle();
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return this.appRes_;
    }

    protected ResourceBundle findApplicationResourceBundle() throws Exception {
        ResourceBundle result;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortletConfigRegistry registry = (PortletConfigRegistry)container.getComponentInstanceOfType(PortletConfigRegistry.class);
        String portlet = this.getApplication().getApplicationName();
        PortletConfig config = registry.getPortletConfig(portlet);
        Locale locale = this.getLocale();
        if (config != null && (result = config.getResourceBundle(locale)) != null) {
            return result;
        }
        return this.getApplication().getResourceBundle(locale);
    }

    public String getActionParameterName() {
        return "op";
    }

    public String getUIComponentIdParameterName() {
        return "uicomponent";
    }

    public abstract URLBuilder<UIComponent> getURLBuilder();

    public abstract String getRequestContextPath();

    public abstract String getPortalContextPath();

    public abstract <T> T getRequest();

    public abstract <T> T getResponse();

    public boolean isResponseComplete() {
        return this.responseComplete_;
    }

    public void setResponseComplete(boolean b) {
        this.responseComplete_ = b;
    }

    public abstract void sendRedirect(String var1) throws Exception;

    public boolean getProcessRender() {
        return this.processRender_;
    }

    public void setProcessRender(boolean b) {
        this.processRender_ = b;
    }

    public Set<UIComponent> getUIComponentToUpdateByAjax() {
        return this.uicomponentToUpdateByAjax;
    }

    public void addUIComponentToUpdateByAjax(UIComponent uicomponent) {
        if (this.uicomponentToUpdateByAjax == null) {
            this.uicomponentToUpdateByAjax = new LinkedHashSet<UIComponent>();
        }
        this.uicomponentToUpdateByAjax.add(uicomponent);
    }

    public ResourceResolver getResourceResolver(String uri) {
        Application app = this.getApplication();
        WebuiRequestContext pcontext = this;
        while (app != null) {
            ApplicationResourceResolver appResolver = app.getResourceResolver();
            ResourceResolver resolver = appResolver.getResourceResolver(uri);
            if (resolver != null) {
                return resolver;
            }
            if ((pcontext = pcontext.getParentAppRequestContext()) != null) {
                app = pcontext.getApplication();
                continue;
            }
            app = null;
        }
        return null;
    }

    public StateManager getStateManager() {
        return this.stateManager_;
    }

    public void setStateManager(StateManager manager) {
        this.stateManager_ = manager;
    }

    public JavascriptManager getJavascriptManager() {
        return ((WebuiRequestContext)this.getParentAppRequestContext()).getJavascriptManager();
    }

    public static String generateUUID() {
        return "uniq-" + UUID.randomUUID().toString();
    }
}

