/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.auth.AbstractSTSLoginModule;
import org.picketlink.identity.federation.core.wstrust.auth.TokenCallback;
import org.w3c.dom.Element;

public class STSValidatingLoginModule
extends AbstractSTSLoginModule {
    public Element invokeSTS(STSClient stsClient) throws WSTrustException, LoginException {
        try {
            Element token = (Element)this.getSharedToken();
            if (token == null) {
                token = this.getSamlTokenFromCaller();
            }
            boolean result = stsClient.validateToken(token);
            logger.debug("SAML Token Validation result: " + result);
            if (!result) {
                throw logger.authCouldNotValidateSAMLToken(token);
            }
            return token;
        }
        catch (IOException e) {
            throw logger.authLoginError(e);
        }
        catch (UnsupportedCallbackException e) {
            throw logger.authLoginError(e);
        }
    }

    private Element getSamlTokenFromCaller() throws UnsupportedCallbackException, LoginException, IOException {
        TokenCallback callback = new TokenCallback();
        this.getCallbackHandler().handle(new Callback[]{callback});
        Element token = (Element)callback.getToken();
        if (token == null) {
            throw logger.authCouldNotLocateSecurityToken();
        }
        return token;
    }
}

