/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.credential;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.picketlink.idm.common.io.IOTools;
import org.picketlink.idm.impl.credential.AbstractHashingWithSaltEncoder;

public class FileReadingSaltEncoder
extends AbstractHashingWithSaltEncoder {
    public static final String OPTION_CREDENTIAL_ENCODER_FILE_LOCATION = "credentialEncoder.fileLocation";
    private String saltPrefix;

    @Override
    protected void afterInitialize() {
        super.afterInitialize();
        String fileLocation = this.getEncoderProperty(OPTION_CREDENTIAL_ENCODER_FILE_LOCATION);
        if (fileLocation == null) {
            throw new IllegalStateException("Property credentialEncoder.fileLocation needs to be provided");
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileLocation);
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(new File(fileLocation));
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException("File not found in classpath or filesystem. File location: " + fileLocation, fnfe);
            }
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            this.saltPrefix = sb.toString();
            this.log.info("Salt successfully read from file " + fileLocation);
        }
        catch (IOException io) {
            throw new RuntimeException("Error reading salt from file " + fileLocation);
        }
        finally {
            IOTools.safeClose((Reader)br);
        }
    }

    @Override
    public String getSalt(String username) {
        return this.saltPrefix + username;
    }
}

