/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.config.ConfigurationException;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.LazyInitializingExecutorService;
import org.infinispan.executors.LazyInitializingScheduledExecutorService;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={ExecutorService.class, Executor.class, ScheduledExecutorService.class})
public class NamedExecutorsFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    private ExecutorService notificationExecutor;
    private ExecutorService asyncTransportExecutor;
    private ScheduledExecutorService evictionExecutor;
    private ScheduledExecutorService asyncReplicationExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.notificationExecutor == null) {
                        this.notificationExecutor = this.buildAndConfigureExecutorService(this.globalConfiguration.getAsyncListenerExecutorFactoryClass(), this.globalConfiguration.getAsyncListenerExecutorProperties(), componentName);
                    }
                }
                return (T)this.notificationExecutor;
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncTransportExecutor == null) {
                        this.asyncTransportExecutor = this.buildAndConfigureExecutorService(this.globalConfiguration.getAsyncTransportExecutorFactoryClass(), this.globalConfiguration.getAsyncTransportExecutorProperties(), componentName);
                    }
                }
                return (T)this.asyncTransportExecutor;
            }
            if (componentName.equals("org.infinispan.executors.eviction")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.evictionExecutor == null) {
                        this.evictionExecutor = this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.getEvictionScheduledExecutorFactoryClass(), this.globalConfiguration.getEvictionScheduledExecutorProperties(), componentName);
                    }
                }
                return (T)this.evictionExecutor;
            }
            if (componentName.equals("org.infinispan.executors.replicationQueue")) {
                NamedExecutorsFactory namedExecutorsFactory = this;
                synchronized (namedExecutorsFactory) {
                    if (this.asyncReplicationExecutor == null) {
                        this.asyncReplicationExecutor = this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.getReplicationQueueScheduledExecutorFactoryClass(), this.globalConfiguration.getReplicationQueueScheduledExecutorProperties(), componentName);
                    }
                }
                return (T)this.asyncReplicationExecutor;
            }
            throw new ConfigurationException("Unknown named executor " + componentName);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, e);
        }
    }

    @Stop(priority=999)
    public void stop() {
        if (this.notificationExecutor != null) {
            this.notificationExecutor.shutdownNow();
        }
        if (this.asyncTransportExecutor != null) {
            this.asyncTransportExecutor.shutdownNow();
        }
        if (this.asyncReplicationExecutor != null) {
            this.asyncReplicationExecutor.shutdownNow();
        }
        if (this.evictionExecutor != null) {
            this.evictionExecutor.shutdownNow();
        }
    }

    private ExecutorService buildAndConfigureExecutorService(String factoryName, Properties p, String componentName) throws Exception {
        Properties props = new Properties(p);
        if (p != null && !p.isEmpty()) {
            props.putAll((Map<?, ?>)p);
        }
        ExecutorFactory f = (ExecutorFactory)Util.getInstance(factoryName, this.globalConfiguration.getClassLoader());
        this.setComponentName(componentName, props);
        this.setDefaultThreads(KnownComponentNames.getDefaultThreads(componentName), props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        return new LazyInitializingExecutorService(f, props);
    }

    private ScheduledExecutorService buildAndConfigureScheduledExecutorService(String factoryName, Properties p, String componentName) throws Exception {
        Properties props = new Properties();
        if (p != null && !p.isEmpty()) {
            props.putAll((Map<?, ?>)p);
        }
        ScheduledExecutorFactory f = (ScheduledExecutorFactory)Util.getInstance(factoryName, this.globalConfiguration.getClassLoader());
        this.setComponentName(componentName, props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        return new LazyInitializingScheduledExecutorService(f, props);
    }

    private void setDefaultThreadPrio(int prio, Properties props) {
        if (!props.containsKey("threadPriority")) {
            props.setProperty("threadPriority", String.valueOf(prio));
        }
    }

    private void setDefaultThreads(int numThreads, Properties props) {
        if (!props.containsKey("maxThreads")) {
            props.setProperty("maxThreads", String.valueOf(numThreads));
        }
    }

    private void setComponentName(String cn, Properties p) {
        if (cn != null) {
            p.setProperty("componentName", this.format(cn));
        }
    }

    private String format(String cn) {
        int dotIndex = cn.lastIndexOf(".");
        int dotIndexPlusOne = dotIndex + 1;
        String cname = cn;
        if (dotIndexPlusOne == cn.length()) {
            cname = this.format(cn.substring(0, cn.length() - 1));
        } else {
            if (dotIndex > -1 && cn.length() > dotIndexPlusOne) {
                cname = cn.substring(dotIndexPlusOne);
            }
            cname = cname + "-thread";
        }
        return cname;
    }
}

