/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

@Internal
class SttbUtils {
    private static final int CBEXTRA_STTB_SAVED_BY = 0;
    private static final int CBEXTRA_STTBF_BKMK = 0;
    private static final int CBEXTRA_STTBF_R_MARK = 0;
    private static final int CDATA_SIZE_STTB_SAVED_BY = 2;
    private static final int CDATA_SIZE_STTBF_BKMK = 2;
    private static final int CDATA_SIZE_STTBF_R_MARK = 2;

    SttbUtils() {
    }

    static Sttb read(int cDataLength, byte[] buffer, int startOffset) {
        short ffff = LittleEndian.getShort((byte[])buffer, (int)startOffset);
        int offset = startOffset + 2;
        if (ffff != -1) {
            throw new UnsupportedOperationException("Non-extended character Pascal strings are not supported right now. Please, contact POI developers for update.");
        }
        int cData = cDataLength == 2 ? LittleEndian.getUShort((byte[])buffer, (int)offset) : LittleEndian.getInt((byte[])buffer, (int)offset);
        Sttb sttb = new Sttb();
        sttb.cDataLength = cDataLength;
        sttb.cbExtra = LittleEndian.getUShort((byte[])buffer, (int)(offset += cDataLength));
        offset += 2;
        sttb.data = new String[cData];
        sttb.extraData = new byte[cData][];
        for (int i = 0; i < cData; ++i) {
            short cchData = LittleEndian.getShort((byte[])buffer, (int)offset);
            offset += 2;
            if (cchData < 0) continue;
            sttb.data[i] = StringUtil.getFromUnicodeLE((byte[])buffer, (int)offset, (int)cchData);
            sttb.extraData[i] = LittleEndian.getByteArray((byte[])buffer, (int)(offset += cchData * 2), (int)sttb.cbExtra);
            offset += sttb.cbExtra;
        }
        return sttb;
    }

    static String[] readSttbfBkmk(byte[] buffer, int startOffset) {
        return SttbUtils.read((int)2, (byte[])buffer, (int)startOffset).data;
    }

    static String[] readSttbfRMark(byte[] buffer, int startOffset) {
        return SttbUtils.read((int)2, (byte[])buffer, (int)startOffset).data;
    }

    static String[] readSttbSavedBy(byte[] buffer, int startOffset) {
        return SttbUtils.read((int)2, (byte[])buffer, (int)startOffset).data;
    }

    static void write(Sttb sttb, HWPFOutputStream tableStream) throws IOException {
        int headerSize = sttb.cDataLength == 2 ? 6 : 8;
        byte[] header = new byte[headerSize];
        LittleEndian.putShort((byte[])header, (int)0, (short)-1);
        if (sttb.data == null || sttb.data.length == 0) {
            if (sttb.cDataLength == 4) {
                LittleEndian.putInt((byte[])header, (int)2, (int)0);
                LittleEndian.putUShort((byte[])header, (int)6, (int)sttb.cbExtra);
                tableStream.write(header);
                return;
            }
            LittleEndian.putUShort((byte[])header, (int)2, (int)0);
            LittleEndian.putUShort((byte[])header, (int)4, (int)sttb.cbExtra);
            tableStream.write(header);
            return;
        }
        if (sttb.cDataLength == 4) {
            LittleEndian.putInt((byte[])header, (int)2, (int)sttb.data.length);
            LittleEndian.putUShort((byte[])header, (int)6, (int)sttb.cbExtra);
            tableStream.write(header);
        } else {
            LittleEndian.putUShort((byte[])header, (int)2, (int)sttb.data.length);
            LittleEndian.putUShort((byte[])header, (int)4, (int)sttb.cbExtra);
            tableStream.write(header);
        }
        for (int i = 0; i < sttb.data.length; ++i) {
            String entry = sttb.data[i];
            if (entry == null) {
                tableStream.write(new byte[]{-1, 0});
                continue;
            }
            byte[] buf = new byte[entry.length() * 2 + sttb.cbExtra + 2];
            LittleEndian.putShort((byte[])buf, (int)0, (short)((short)entry.length()));
            StringUtil.putUnicodeLE((String)entry, (byte[])buf, (int)2);
            if (sttb.extraData != null && i < sttb.extraData.length && sttb.extraData[i] != null) {
                System.arraycopy(sttb.extraData[i], 0, buf, entry.length() * 2, Math.min(sttb.extraData[i].length, sttb.cbExtra));
            }
            tableStream.write(buf);
        }
    }

    static void writeSttbfBkmk(String[] data, HWPFOutputStream tableStream) throws IOException {
        Sttb sttb = new Sttb();
        sttb.cDataLength = 2;
        sttb.data = data;
        sttb.cbExtra = 0;
        SttbUtils.write(sttb, tableStream);
    }

    static void writeSttbfRMark(String[] data, HWPFOutputStream tableStream) throws IOException {
        Sttb sttb = new Sttb();
        sttb.cDataLength = 2;
        sttb.data = data;
        sttb.cbExtra = 0;
        SttbUtils.write(sttb, tableStream);
    }

    static void writeSttbSavedBy(String[] data, HWPFOutputStream tableStream) throws IOException {
        Sttb sttb = new Sttb();
        sttb.cDataLength = 2;
        sttb.data = data;
        sttb.cbExtra = 0;
        SttbUtils.write(sttb, tableStream);
    }

    static class Sttb {
        public int cbExtra;
        public int cDataLength;
        public String[] data;
        public byte[][] extraData;

        Sttb() {
        }
    }
}

