/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.management.exportimport.NavigationImportTask;
import org.exoplatform.portal.mop.management.exportimport.PageImportTask;
import org.exoplatform.portal.mop.management.exportimport.SiteLayoutExportTask;
import org.exoplatform.portal.mop.management.exportimport.SiteLayoutImportTask;
import org.exoplatform.portal.mop.management.operations.MOPSiteProvider;
import org.exoplatform.portal.mop.management.operations.Utils;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationAttachment;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.NoResultModel;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public class MopImportResource
implements OperationHandler {
    private static final Logger log = LoggerFactory.getLogger(MopImportResource.class);

    public void execute(OperationContext operationContext, ResultHandler resultHandler) throws ResourceNotFoundException, OperationException {
        ImportMode importMode;
        String operationName = operationContext.getOperationName();
        OperationAttachment attachment = operationContext.getAttachment(true);
        if (attachment == null) {
            throw new OperationException(operationContext.getOperationName(), "No attachment available for MOP import.");
        }
        InputStream inputStream = attachment.getStream();
        if (inputStream == null) {
            throw new OperationException(operationContext.getOperationName(), "No data stream available for import.");
        }
        final POMSessionManager mgr = (POMSessionManager)operationContext.getRuntimeContext().getRuntimeComponent(POMSessionManager.class);
        POMSession session = mgr.getSession();
        if (session == null) {
            throw new OperationException(operationName, "MOP session was null");
        }
        Workspace workspace = session.getWorkspace();
        if (workspace == null) {
            throw new OperationException(operationName, "MOP workspace was null");
        }
        DataStorage dataStorage = (DataStorage)operationContext.getRuntimeContext().getRuntimeComponent(DataStorage.class);
        if (dataStorage == null) {
            throw new OperationException(operationName, "DataStorage was null");
        }
        PageService pageService = (PageService)operationContext.getRuntimeContext().getRuntimeComponent(PageService.class);
        if (pageService == null) {
            throw new OperationException(operationName, "PageService was null");
        }
        NavigationService navigationService = (NavigationService)operationContext.getRuntimeContext().getRuntimeComponent(NavigationService.class);
        if (navigationService == null) {
            throw new OperationException(operationName, "Navigation service was null");
        }
        DescriptionService descriptionService = (DescriptionService)operationContext.getRuntimeContext().getRuntimeComponent(DescriptionService.class);
        if (descriptionService == null) {
            throw new OperationException(operationName, "Description service was null");
        }
        String mode = operationContext.getAttributes().getValue("importMode");
        if (mode == null || "".equals(mode)) {
            mode = "merge";
        }
        try {
            importMode = ImportMode.valueOf(mode.trim().toUpperCase());
        }
        catch (Exception e) {
            throw new OperationException(operationName, "Unknown importMode " + mode);
        }
        HashMap<SiteKey, MopImport> importMap = new HashMap<SiteKey, MopImport>();
        NonCloseableZipInputStream zis = new NonCloseableZipInputStream(inputStream);
        boolean empty = false;
        try {
            ZipEntry entry;
            log.info((Object)"Preparing data for import.");
            while ((entry = zis.getNextEntry()) != null) {
                Marshaller marshaller;
                if (entry.isDirectory() || (empty = entry.getName().equals(""))) continue;
                String[] parts = MopImportResource.parseEntry(entry);
                SiteKey siteKey = Utils.siteKey(parts[0], parts[1]);
                String file = parts[2];
                MopImport mopImport = (MopImport)importMap.get(siteKey);
                if (mopImport == null) {
                    mopImport = new MopImport();
                    importMap.put(siteKey, mopImport);
                }
                if (SiteLayoutExportTask.FILES.contains(file)) {
                    marshaller = operationContext.getBindingProvider().getMarshaller(PortalConfig.class, ContentType.XML);
                    PortalConfig portalConfig = (PortalConfig)marshaller.unmarshal((InputStream)zis);
                    portalConfig.setType(siteKey.getTypeName());
                    if (!portalConfig.getName().equals(siteKey.getName())) {
                        throw new OperationException(operationName, "Name of site does not match that of the zip entry site name.");
                    }
                    mopImport.siteTask = new SiteLayoutImportTask(portalConfig, siteKey, dataStorage);
                    continue;
                }
                if (file.equals("pages.xml")) {
                    marshaller = operationContext.getBindingProvider().getMarshaller(Page.PageSet.class, ContentType.XML);
                    Page.PageSet pages = (Page.PageSet)marshaller.unmarshal((InputStream)zis);
                    for (Page page : pages.getPages()) {
                        page.setOwnerType(siteKey.getTypeName());
                        page.setOwnerId(siteKey.getName());
                    }
                    MOPSiteProvider siteProvider = new MOPSiteProvider(){

                        @Override
                        public Site getSite(SiteKey siteKey) {
                            return mgr.getSession().getWorkspace().getSite(Utils.getObjectType(siteKey.getType()), siteKey.getName());
                        }
                    };
                    mopImport.pageTask = new PageImportTask(pages, siteKey, dataStorage, pageService, siteProvider);
                    continue;
                }
                if (!file.equals("navigation.xml")) continue;
                marshaller = operationContext.getBindingProvider().getMarshaller(PageNavigation.class, ContentType.XML);
                PageNavigation navigation = (PageNavigation)marshaller.unmarshal((InputStream)zis);
                navigation.setOwnerType(siteKey.getTypeName());
                navigation.setOwnerId(siteKey.getName());
                mopImport.navigationTask = new NavigationImportTask(navigation, siteKey, navigationService, descriptionService, dataStorage);
            }
            resultHandler.completed((Object)NoResultModel.INSTANCE);
        }
        catch (Throwable t) {
            throw new OperationException(operationContext.getOperationName(), "Exception reading data for import.", t);
        }
        finally {
            try {
                zis.reallyClose();
            }
            catch (IOException e) {
                log.warn((Object)"Exception closing underlying data stream from import.");
            }
        }
        if (empty) {
            log.info((Object)"Nothing to import, zip file empty.");
            return;
        }
        HashMap<SiteKey, MopImport> importsRan = new HashMap<SiteKey, MopImport>();
        try {
            log.info((Object)("Performing import using importMode '" + mode + "'"));
            for (Map.Entry mopImportEntry : importMap.entrySet()) {
                SiteKey siteKey = (SiteKey)mopImportEntry.getKey();
                MopImport mopImport = (MopImport)mopImportEntry.getValue();
                MopImport ran = new MopImport();
                if (importsRan.containsKey(siteKey)) {
                    throw new IllegalStateException("Multiple site imports for same operation.");
                }
                importsRan.put(siteKey, ran);
                log.debug((Object)("Importing data for site " + siteKey));
                if (mopImport.siteTask != null) {
                    log.debug((Object)"Importing site layout data.");
                    ran.siteTask = mopImport.siteTask;
                    mopImport.siteTask.importData(importMode);
                }
                if (mopImport.pageTask != null) {
                    log.debug((Object)"Importing page data.");
                    ran.pageTask = mopImport.pageTask;
                    mopImport.pageTask.importData(importMode);
                }
                if (mopImport.navigationTask == null) continue;
                log.debug((Object)"Importing navigation data.");
                ran.navigationTask = mopImport.navigationTask;
                mopImport.navigationTask.importData(importMode);
            }
            log.info((Object)"Import successful !");
        }
        catch (Throwable t) {
            boolean rollbackSuccess = true;
            log.error((Object)"Exception importing data.", t);
            log.info((Object)"Attempting to rollback data modified by import.");
            for (Map.Entry mopImportEntry : importsRan.entrySet()) {
                SiteKey siteKey = (SiteKey)mopImportEntry.getKey();
                MopImport mopImport = (MopImport)mopImportEntry.getValue();
                log.debug((Object)("Rolling back imported data for site " + siteKey));
                if (mopImport.navigationTask != null) {
                    log.debug((Object)"Rolling back navigation modified during import...");
                    try {
                        mopImport.navigationTask.rollback();
                    }
                    catch (Throwable t1) {
                        rollbackSuccess = false;
                        log.error((Object)("Error rolling back navigation data for site " + siteKey), t1);
                    }
                }
                if (mopImport.pageTask != null) {
                    log.debug((Object)"Rolling back pages modified during import...");
                    try {
                        mopImport.pageTask.rollback();
                    }
                    catch (Throwable t1) {
                        rollbackSuccess = false;
                        log.error((Object)("Error rolling back page data for site " + siteKey), t1);
                    }
                }
                if (mopImport.siteTask == null) continue;
                log.debug((Object)"Rolling back site layout modified during import...");
                try {
                    mopImport.siteTask.rollback();
                }
                catch (Throwable t1) {
                    rollbackSuccess = false;
                    log.error((Object)("Error rolling back site layout for site " + siteKey), t1);
                }
            }
            String message = rollbackSuccess ? "Error during import. Tasks successfully rolled back. Portal should be back to consistent state." : "Error during import. Errors in rollback as well. Portal may be in an inconsistent state.";
            throw new OperationException(operationName, message, t);
        }
        finally {
            importMap.clear();
            importsRan.clear();
        }
    }

    private static String[] parseEntry(ZipEntry entry) throws IOException {
        String name = entry.getName();
        if (MopImportResource.isSiteLayoutEntry(name) || name.endsWith("pages.xml") || name.endsWith("navigation.xml")) {
            String[] parts;
            parts = new String[]{name.substring(0, name.indexOf("/")), name.substring(parts[0].length() + 1, name.lastIndexOf("/")), name.substring(name.lastIndexOf("/") + 1)};
            return parts;
        }
        throw new IOException("Unknown entry " + name + " in zip file.");
    }

    private static boolean isSiteLayoutEntry(String zipEntryName) {
        for (String file : SiteLayoutExportTask.FILES) {
            if (!zipEntryName.endsWith(file)) continue;
            return true;
        }
        return false;
    }

    private static class MopImport {
        private SiteLayoutImportTask siteTask;
        private PageImportTask pageTask;
        private NavigationImportTask navigationTask;

        private MopImport() {
        }
    }

    private static class NonCloseableZipInputStream
    extends ZipInputStream {
        private NonCloseableZipInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
        }

        private void reallyClose() throws IOException {
            super.close();
        }
    }
}

