/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.DBTableManager;
import org.exoplatform.services.database.QueryBuilder;
import org.exoplatform.services.database.table.IDGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoDatasource {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.database.ExoDatasource");
    public static final int STANDARD_DB_TYPE = 0;
    public static final int HSQL_DB_TYPE = 1;
    public static final int MYSQL_DB_TYPE = 2;
    public static final int DB2_DB_TYPE = 3;
    public static final int DERBY_DB_TYPE = 4;
    public static final int ORACLE_DB_TYPE = 5;
    public static final int SQL_SERVER_TYPE = 6;
    static int totalGetConnect = 0;
    public static final int MSSQL_DB_TYPE = 6;
    public static final int SYSBASE_DB_TYPE = 7;
    public static final int POSTGRES_DB_TYPE = 8;
    private DataSource xaDatasource_;
    private DBTableManager tableManager_;
    private IDGenerator idGenerator_;
    private QueryBuilder queryManager_;
    private String databaseName_;
    private String databaseVersion_;
    private int dbType_ = 0;
    Connection conn;

    public ExoDatasource(final DataSource ds) throws Exception {
        this.xaDatasource_ = ds;
        DatabaseMetaData metaData = (DatabaseMetaData)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<DatabaseMetaData>(){

            @Override
            public DatabaseMetaData run() throws SQLException {
                return ds.getConnection().getMetaData();
            }
        });
        this.databaseName_ = metaData.getDatabaseProductName();
        this.databaseVersion_ = metaData.getDatabaseProductVersion();
        String dbname = this.databaseName_.toLowerCase();
        LOG.debug((Object)("DB Name: " + dbname));
        this.dbType_ = dbname.indexOf("oracle") >= 0 ? 5 : (dbname.indexOf("hsql") >= 0 ? 1 : (dbname.indexOf("mysql") >= 0 ? 2 : (dbname.indexOf("derby") >= 0 ? 4 : (dbname.indexOf("db2") >= 0 ? 3 : (dbname.indexOf("server") >= 0 ? 6 : 0)))));
        this.tableManager_ = DBTableManager.createDBTableManager(this);
        this.idGenerator_ = new IDGenerator(this);
        this.queryManager_ = new QueryBuilder(this.dbType_);
    }

    public DataSource getDatasource() {
        return this.xaDatasource_;
    }

    public Connection getConnection() throws Exception {
        return this.xaDatasource_.getConnection();
    }

    public void closeConnection(Connection conn) throws Exception {
        conn.close();
    }

    public void commit(Connection conn) throws Exception {
        conn.setAutoCommit(false);
        conn.commit();
    }

    public DBTableManager getDBTableManager() {
        return this.tableManager_;
    }

    public IDGenerator getIDGenerator() {
        return this.idGenerator_;
    }

    public int getDatabaseType() {
        return this.dbType_;
    }

    public String getDatabaseName() {
        return this.databaseName_;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion_;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryManager_;
    }
}

