/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.parser.html.Namespaces;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.Strings;
import java.io.IOException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElKey
implements MessagePart,
Comparable<ElKey> {
    public final Namespaces ns;
    public final String localName;
    private static final Namespaces HTML_NS = Namespaces.HTML_DEFAULT.forUri("http://www.w3.org/1999/xhtml");
    public static final ElKey HTML_WILDCARD = new ElKey(Namespaces.HTML_DEFAULT, "*");
    private int hc;

    private ElKey(Namespaces ns, String localName) {
        assert (ns != null && localName != null);
        this.ns = ns;
        this.localName = localName;
    }

    public static ElKey wildcard(Namespaces ns) {
        if (ns.uri == "http://www.w3.org/1999/xhtml") {
            return HTML_WILDCARD;
        }
        return new ElKey(ns, "*");
    }

    public boolean isHtml() {
        return this.ns.uri == "http://www.w3.org/1999/xhtml";
    }

    public boolean is(Element el) {
        return this.ns.uri.equals(el.getNamespaceURI()) && ("*".equals(this.localName) || this.localName.equals(el.getLocalName()));
    }

    public static ElKey forHtmlElement(String localName) {
        return new ElKey(HTML_NS, Strings.toLowerCase(localName));
    }

    public static ElKey forElement(Namespaces inScope, String qname) {
        int colon = qname.indexOf(58);
        String localName = colon < 0 ? qname : qname.substring(colon + 1);
        Namespaces ns = inScope.forElementName(qname);
        if (ns == null) {
            return null;
        }
        ns = inScope.forUri(ns.uri);
        if (ns.uri == "http://www.w3.org/1999/xhtml") {
            localName = Strings.toLowerCase(localName);
        }
        return new ElKey(ns, localName);
    }

    public static ElKey forElement(Element el) {
        String uri = el.getNamespaceURI();
        String localName = el.getLocalName();
        Namespaces ns = Namespaces.HTML_DEFAULT.forUri(uri);
        if (ns == null) {
            ns = new Namespaces(Namespaces.XML_SPECIAL, "", uri);
        }
        if (ns.uri == "http://www.w3.org/1999/xhtml") {
            localName = Strings.toLowerCase(localName);
        }
        return new ElKey(ns, localName);
    }

    @Override
    public void format(MessageContext mc, Appendable out) throws IOException {
        if (!"".equals(this.ns.prefix)) {
            out.append(this.ns.prefix).append(':');
        }
        out.append(this.localName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElKey)) {
            return false;
        }
        ElKey that = (ElKey)o;
        return this.ns.uri == that.ns.uri && this.localName.equals(that.localName);
    }

    public int hashCode() {
        if (this.hc == 0) {
            int hc = this.ns.uri.hashCode() + 31 * this.localName.hashCode();
            this.hc = hc != 0 ? hc : -1;
        }
        return this.hc;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (!"".equals(this.ns.prefix)) {
            out.append(this.ns.prefix).append(':');
        }
        return out.append(this.localName).toString();
    }

    @Override
    public int compareTo(ElKey that) {
        int delta = this.ns.uri.compareTo(that.ns.uri);
        if (delta != 0) {
            return delta;
        }
        return this.localName.compareTo(that.localName);
    }
}

