/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.AbstractSocialSearchConnector;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class PeopleSearchConnector
extends AbstractSocialSearchConnector {
    private IdentityManager identityManager;
    private static final Log LOG = ExoLogger.getLogger(PeopleSearchConnector.class);

    public PeopleSearchConnector(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    @Override
    public Collection<SearchResult> search(SearchContext context, String query, AbstractSocialSearchConnector.Range range, Sorting sorting) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        ProfileFilter filter = new ProfileFilter();
        filter.setAll(query);
        filter.setSorting(sorting);
        ListAccess<Identity> la = this.identityManager.getIdentitiesForUnifiedSearch("organization", filter);
        try {
            Identity[] identities = (Identity[])la.load(range.offset, range.limit);
            RowIterator rowIt = this.rows(this.buildQuery(filter), range.offset, range.limit);
            Row row = null;
            for (Identity i : identities) {
                List phones;
                Profile p = i.getProfile();
                StringBuilder sb = new StringBuilder();
                if (p.getEmail() != null) {
                    sb.append(p.getEmail());
                }
                if ((phones = (List)p.getProperty("phones")) != null && phones.size() > 0) {
                    sb.append(" - " + ((Map)phones.get(0)).get("value"));
                }
                if (p.getProperty("gender") != null) {
                    sb.append(" - " + p.getProperty("gender"));
                }
                row = rowIt != null && rowIt.hasNext() ? rowIt.nextRow() : null;
                SearchResult result = new SearchResult(p.getUrl(), p.getFullName(), p.getPosition(), sb.toString(), p.getAvatarUrl() != null ? p.getAvatarUrl() : "/social-resources/skin/images/ShareImages/UserAvtDefault.png", p.getCreatedTime(), this.getRelevancy(row));
                results.add(result);
            }
        }
        catch (IllegalArgumentException aex) {
            LOG.warn((Object)aex.getMessage());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return results;
    }

    private String buildQuery(ProfileFilter filter) {
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get("organization").getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        if (filter.getAll().length() != 0) {
            String value = filter.getAll();
            whereExpression.and().startGroup().contains(ProfileEntity.fullName, value.toLowerCase()).or().contains(ProfileEntity.firstName, value.toLowerCase()).or().contains(ProfileEntity.lastName, value.toLowerCase()).or().contains(ProfileEntity.position, value.toLowerCase()).or().contains(ProfileEntity.skills, value.toLowerCase()).or().contains(ProfileEntity.positions, value.toLowerCase()).or().contains(ProfileEntity.organizations, value.toLowerCase()).or().contains(ProfileEntity.jobsDescription, value.toLowerCase()).endGroup();
        }
        StringBuilder sb = new StringBuilder("SELECT ").append(JCRProperties.JCR_EXCERPT.getName()).append(" FROM ");
        sb.append("soc:profiledefinition");
        sb.append(" WHERE ");
        sb.append(whereExpression.toString());
        sb.append(this.applyOrder(filter));
        return sb.toString();
    }

    private String applyOrder(ProfileFilter filter) {
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        Sorting sorting = filter == null ? new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC) : filter.getSorting();
        switch (sorting.sortBy) {
            case DATE: {
                sb.append(ProfileEntity.createdTime.getName()).append(" ").append(sorting.orderBy.toString());
                break;
            }
            case RELEVANCY: {
                sb.append(JCRProperties.JCR_RELEVANCY.getName()).append(" ").append(sorting.orderBy.toString());
                break;
            }
            case TITLE: {
                sb.append(ProfileEntity.fullName.getName()).append(" ").append(sorting.orderBy.toString());
            }
        }
        return sb.toString();
    }
}

