/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.updater;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.ActivityStreamStorageImpl;

public abstract class StreamUpgradeProcessor {
    private IdentityStorage identityStorage = null;
    private ActivityStorage activityStorage = null;
    private ActivityStreamStorage streamStorage = null;
    private final Identity owner;
    private final ActivityStreamStorageImpl.ActivityRefType type;

    abstract List<ExoSocialActivity> load(Identity var1, int var2, int var3);

    abstract int size(Identity var1);

    public void upgrade() {
        int offset = 0;
        int limit = 100;
        int totalSize = this.size(this.owner);
        limit = Math.min(limit, totalSize);
        int loaded = this.upgradeRange(offset, limit);
        if (limit != totalSize) {
            while (loaded == 100) {
                if ((offset += limit) + limit > totalSize) {
                    limit = totalSize - offset;
                }
                loaded = this.upgradeRange(offset, limit);
            }
        }
    }

    public void upgrade(int offset, int limit) {
        if (limit == -1) {
            this.upgrade();
        } else {
            this.upgradeRange(offset, limit);
            this.upgradeStreamSize();
        }
    }

    protected IdentityStorage getIdentityStorage() {
        if (this.identityStorage == null) {
            this.identityStorage = (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
        }
        return this.identityStorage;
    }

    protected ActivityStorage getActivityStorage() {
        if (this.activityStorage == null) {
            this.activityStorage = (ActivityStorage)PortalContainer.getInstance().getComponentInstanceOfType(ActivityStorage.class);
        }
        return this.activityStorage;
    }

    protected ActivityStreamStorage getStreamStorage() {
        if (this.streamStorage == null) {
            this.streamStorage = (ActivityStreamStorage)PortalContainer.getInstance().getComponentInstanceOfType(ActivityStreamStorage.class);
        }
        return this.streamStorage;
    }

    public static StreamUpgradeProcessor feed(Identity owner) {
        return new StreamUpgradeProcessor(owner, ActivityStreamStorageImpl.ActivityRefType.FEED){

            @Override
            List<ExoSocialActivity> load(Identity owner, int offset, int limit) {
                return this.getActivityStorage().getActivityFeedForUpgrade(owner, offset, limit);
            }

            @Override
            int size(Identity owner) {
                return this.getActivityStorage().getNumberOfActivitesOnActivityFeedForUpgrade(owner);
            }
        };
    }

    public static StreamUpgradeProcessor connection(Identity owner) {
        return new StreamUpgradeProcessor(owner, ActivityStreamStorageImpl.ActivityRefType.CONNECTION){

            @Override
            List<ExoSocialActivity> load(Identity owner, int offset, int limit) {
                return this.getActivityStorage().getActivityFeedForUpgrade(owner, offset, limit);
            }

            @Override
            int size(Identity owner) {
                return this.getActivityStorage().getNumberOfActivitiesOfConnectionsForUpgrade(owner);
            }
        };
    }

    public static StreamUpgradeProcessor user(Identity owner) {
        return new StreamUpgradeProcessor(owner, ActivityStreamStorageImpl.ActivityRefType.MY_ACTIVITIES){

            @Override
            List<ExoSocialActivity> load(Identity owner, int offset, int limit) {
                return this.getActivityStorage().getUserActivitiesForUpgrade(owner, offset, limit);
            }

            @Override
            int size(Identity owner) {
                return this.getActivityStorage().getNumberOfUserActivitiesForUpgrade(owner);
            }
        };
    }

    public static StreamUpgradeProcessor myspaces(Identity owner) {
        return new StreamUpgradeProcessor(owner, ActivityStreamStorageImpl.ActivityRefType.MY_SPACES){

            @Override
            List<ExoSocialActivity> load(Identity owner, int offset, int limit) {
                return this.getActivityStorage().getUserSpacesActivitiesForUpgrade(owner, offset, limit);
            }

            @Override
            int size(Identity owner) {
                return this.getActivityStorage().getNumberOfUserSpacesActivitiesForUpgrade(owner);
            }
        };
    }

    public static StreamUpgradeProcessor space(Identity owner) {
        return new StreamUpgradeProcessor(owner, ActivityStreamStorageImpl.ActivityRefType.SPACE_STREAM){

            @Override
            List<ExoSocialActivity> load(Identity owner, int offset, int limit) {
                return this.getActivityStorage().getSpaceActivitiesForUpgrade(owner, offset, limit);
            }

            @Override
            int size(Identity owner) {
                return this.getActivityStorage().getNumberOfSpaceActivitiesForUpgrade(owner);
            }
        };
    }

    public StreamUpgradeProcessor(Identity owner, ActivityStreamStorageImpl.ActivityRefType type) {
        this.owner = owner;
        this.type = type;
    }

    private int upgradeRange(int offset, int limit) {
        List<ExoSocialActivity> got = this.load(this.owner, offset, limit);
        if (got.size() > 0) {
            this.getStreamStorage().createActivityRef(this.owner, got, this.type);
        }
        return got.size();
    }

    private int upgradeStreamSize() {
        int got = this.size(this.owner);
        if (got > 0) {
            this.getStreamStorage().migrateStreamSize(this.owner, got, this.type);
        }
        return got;
    }
}

