/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.util.Maps;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DomMembrane {
    private final Map<Object, Object> wrappers = Maps.newIdentityHashMap();

    DomMembrane() {
    }

    <T extends Node> T wrap(T node, Class<T> type) {
        if (node == null) {
            return null;
        }
        Node wrapper = (Node)this.wrappers.get(node);
        if (wrapper == null) {
            wrapper = this.makeWrapper(node, type);
            this.wrappers.put(node, wrapper);
            this.wrappers.put(wrapper, node);
        }
        return (T)((Node)type.cast(wrapper));
    }

    <T extends NodeList> T wrap(T list, Class<T> type) {
        if (list == null) {
            return null;
        }
        NodeList wrapper = (NodeList)this.wrappers.get(list);
        if (wrapper == null) {
            wrapper = this.makeListWrapper(list, type);
            this.wrappers.put(list, wrapper);
            this.wrappers.put(wrapper, list);
        }
        return (T)((NodeList)type.cast(wrapper));
    }

    <T extends NamedNodeMap> T wrap(T map, Class<T> type) {
        if (map == null) {
            return null;
        }
        NamedNodeMap wrapper = (NamedNodeMap)this.wrappers.get(map);
        if (wrapper == null) {
            wrapper = this.makeMapWrapper(map, type);
            this.wrappers.put(map, wrapper);
            this.wrappers.put(wrapper, map);
        }
        return (T)((NamedNodeMap)type.cast(wrapper));
    }

    <T> T unwrap(T node, Class<T> type) {
        if (node == null) {
            return null;
        }
        Node wrapper = (Node)this.wrappers.get(node);
        return wrapper == null ? node : type.cast(wrapper);
    }

    abstract <T extends Node> T makeWrapper(T var1, Class<T> var2);

    abstract <T extends NodeList> T makeListWrapper(T var1, Class<T> var2);

    abstract <T extends NamedNodeMap> T makeMapWrapper(T var1, Class<T> var2);
}

