/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.webui.page.PageModel;

public class PageIterator
implements Iterator<List<?>> {
    private final String ownerType;
    private final String ownerId;
    private final String name;
    private final String title;
    private int pageSize = 10;
    private int currentIndex = 0;
    private boolean hasNext = true;

    public PageIterator(String ownerType, String ownerId, String name, String title, int pageSize) {
        this.ownerType = ownerType;
        this.ownerId = ownerId;
        this.name = name;
        this.title = title;
        this.pageSize = pageSize;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext && this.currentIndex == 0) {
            PortalContainer container = PortalContainer.getInstance();
            PageService pageService = (PageService)container.getComponentInstance(PageService.class);
            QueryResult result = pageService.findPages(0, 1, SiteType.valueOf((String)this.ownerType.toUpperCase()), this.ownerId, this.name, this.title);
            this.hasNext = result.getSize() > 0;
        }
        return this.hasNext;
    }

    @Override
    public List<PageModel> next() {
        PortalContainer container = PortalContainer.getInstance();
        PageService pageService = (PageService)container.getComponentInstance(PageService.class);
        QueryResult result = pageService.findPages(this.currentIndex, this.pageSize + 1, SiteType.valueOf((String)this.ownerType.toUpperCase()), this.ownerId, this.name, this.title);
        int size = result.getSize();
        boolean bl = this.hasNext = size > this.pageSize;
        if (size > 0) {
            int hsize = this.hasNext ? this.pageSize : size;
            ArrayList<PageModel> holder = new ArrayList<PageModel>(hsize);
            Iterator iterator = result.iterator();
            while (holder.size() < hsize) {
                holder.add(new PageModel((PageContext)iterator.next()));
            }
            this.currentIndex += holder.size();
            return holder;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

