/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;

public class NativeHttpSSOAgent
extends HttpSSOAgent {
    private static final Log log = LogFactory.getLog(NativeHttpSSOAgent.class);

    protected Principal authenticate(SSOAgentRequest request) {
        String ssoSessionId = request.getSessionId();
        try {
            if (ssoSessionId == null) {
                log.debug((Object)("Session authentication failed : " + ssoSessionId));
                return null;
            }
            SSOUser ssoUser = this.getSSOIdentityManager().findUserInSession(request.getRequester(), ssoSessionId);
            log.debug((Object)("Session authentication succeeded : " + ssoSessionId));
            return ssoUser;
        }
        catch (SSOIdentityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Session authentication failed : " + ssoSessionId), (Throwable)e);
            throw new RuntimeException("Fatal error authenticating session : " + e);
        }
    }

    protected void log(String message) {
        if (this.debug > 0) {
            log.debug((Object)message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.debug > 0) {
            log.debug((Object)message, throwable);
        }
    }
}

