/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;

public class Resources
extends Dictionary {
    private static int uniqueCounter = 0;
    private static final Logger logger = Logger.getLogger(Resources.class.toString());
    Hashtable fonts;
    Hashtable xobjects;
    Hashtable colorspaces;
    Hashtable patterns;
    Hashtable shading;
    Hashtable extGStates;
    private int referenceCount;

    private static synchronized int getUniqueId() {
        return uniqueCounter++;
    }

    public Resources(Library l, Hashtable h) {
        super(l, h);
        this.colorspaces = this.library.getDictionary(this.entries, "ColorSpace");
        this.fonts = this.library.getDictionary(this.entries, "Font");
        this.xobjects = this.library.getDictionary(this.entries, "XObject");
        this.patterns = this.library.getDictionary(this.entries, "Pattern");
        this.shading = this.library.getDictionary(this.entries, "Shading");
        this.extGStates = this.library.getDictionary(this.entries, "ExtGState");
        this.referenceCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(Object referer) {
        Resources resources = this;
        synchronized (resources) {
            ++this.referenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(Object referer) {
        Resources resources = this;
        synchronized (resources) {
            --this.referenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose(boolean cache, Dictionary referer) {
        Resources resources = this;
        synchronized (resources) {
            --this.referenceCount;
            if (this.referenceCount > 0) {
                return false;
            }
        }
        if (this.xobjects != null) {
            Enumeration xobjectContent = this.xobjects.elements();
            while (xobjectContent.hasMoreElements()) {
                Object tmp = xobjectContent.nextElement();
                if (tmp instanceof Stream) {
                    Stream stream = (Stream)tmp;
                    stream.dispose(cache);
                }
                if (!(tmp instanceof Reference)) continue;
                Object reference = this.library.getObject((Reference)tmp);
                if (reference instanceof Form) {
                    Form form = (Form)reference;
                    form.dispose(cache);
                }
                if (!(reference instanceof Stream)) continue;
                Stream stream = (Stream)reference;
                stream.dispose(cache);
            }
        }
        this.clearResource(this.colorspaces);
        this.clearResource(this.fonts);
        this.clearResource(this.xobjects);
        this.clearResource(this.patterns);
        this.clearResource(this.shading);
        this.clearResource(this.extGStates);
        return true;
    }

    private void clearResource(Hashtable resource) {
        if (resource != null) {
            Set keys = resource.keySet();
            for (Object key : keys) {
                Object value = resource.get(key);
                if (!(value instanceof Reference)) continue;
                this.library.removeObject((Reference)value);
            }
        }
    }

    public PColorSpace getColorSpace(Object o) {
        if (o == null) {
            return null;
        }
        if (this.colorspaces != null && this.colorspaces.get(o) != null) {
            Object tmp = this.colorspaces.get(o);
            PColorSpace cs = PColorSpace.getColorSpace(this.library, tmp);
            if (cs != null) {
                cs.init();
            }
            return cs;
        }
        if (this.patterns != null && this.patterns.get(o) != null) {
            Object tmp = this.patterns.get(o);
            PColorSpace cs = PColorSpace.getColorSpace(this.library, tmp);
            if (cs != null) {
                cs.init();
            }
            return cs;
        }
        PColorSpace cs = PColorSpace.getColorSpace(this.library, o);
        if (cs != null) {
            cs.init();
        }
        return cs;
    }

    public Font getFont(String s) {
        Font font = null;
        if (this.fonts != null) {
            Object ob = this.fonts.get(s);
            if (ob instanceof Font) {
                font = (Font)ob;
            } else if (ob instanceof Reference) {
                font = (Font)this.library.getObject((Reference)ob);
            }
        }
        if (font != null) {
            font.init();
        }
        return font;
    }

    public Image getImage(String s, Color fill) {
        Stream st = (Stream)this.library.getObject(this.xobjects, s);
        if (st == null) {
            return null;
        }
        if (!st.isImageSubtype()) {
            return null;
        }
        BufferedImage image = null;
        try {
            image = st.getImage(fill, this, true);
            st.dispose(true);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error getting image by name: " + s, e);
        }
        return image;
    }

    public boolean isForm(String s) {
        Object o = this.library.getObject(this.xobjects, s);
        return o instanceof Form;
    }

    public Form getForm(String nameReference) {
        Form formXObject = null;
        Object tempForm = this.library.getObject(this.xobjects, nameReference);
        if (tempForm instanceof Form) {
            formXObject = (Form)tempForm;
        }
        return formXObject;
    }

    public Pattern getPattern(String name) {
        if (this.patterns != null) {
            Object attribute = this.library.getObject(this.patterns, name);
            if (attribute != null && attribute instanceof TilingPattern) {
                return (TilingPattern)attribute;
            }
            if (attribute != null && attribute instanceof Stream) {
                return new TilingPattern((Stream)attribute);
            }
            if (attribute != null && attribute instanceof Hashtable) {
                return ShadingPattern.getShadingPattern(this.library, (Hashtable)attribute);
            }
        }
        return null;
    }

    public ShadingPattern getShading(String name) {
        Object shadingDictionary;
        if (this.shading != null && (shadingDictionary = this.library.getObject(this.shading, name)) != null && shadingDictionary instanceof Hashtable) {
            return ShadingPattern.getShadingPattern(this.library, this.entries, (Hashtable)shadingDictionary);
        }
        return null;
    }

    public ExtGState getExtGState(String namedReference) {
        ExtGState gsState = null;
        if (this.extGStates != null) {
            Object attribute = this.library.getObject(this.extGStates, namedReference);
            if (attribute instanceof Hashtable) {
                gsState = new ExtGState(this.library, (Hashtable)attribute);
            } else if (attribute instanceof Reference) {
                gsState = new ExtGState(this.library, (Hashtable)this.library.getObject((Reference)attribute));
            }
        }
        return gsState;
    }
}

