/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.ExoScriptingConsole;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Scanner;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class ExoScriptingConsole {
    ScriptEngine _engine;
    StringWriter _out = new StringWriter();
    StringWriter _err = new StringWriter();
    PrintWriter _stdout = new PrintWriter(this._out);
    PrintWriter _stderr = new PrintWriter(this._err);
    StringBuilder _history;

    public ExoScriptingConsole(String engineName) throws Exception {
        this._engine = new ScriptEngineManager().getEngineByName(engineName);
        if (this._engine == null) {
            throw new Exception("Cannot find script engine '" + engineName + "'");
        }
        ScriptContext context = this._engine.getContext();
        context.setWriter(this._stdout);
        context.setErrorWriter(this._stderr);
        this._history = new StringBuilder();
    }

    public String run(String script) throws Exception {
        this._out.getBuffer().setLength(0);
        this._engine.eval(script);
        this._history.append(script).append("\n");
        this._stdout.flush();
        return this._out.toString();
    }

    public void runInSystemTerminal(boolean isDebug) {
        String output = "";
        String outputType = "result";
        System.out.print("Type 'help' for available commands\n>> ");
        Scanner scn = new Scanner(System.in);
        while (scn.hasNextLine()) {
            block17: {
                output = "";
                outputType = "result";
                try {
                    String script = scn.nextLine();
                    if (script.isEmpty()) {
                        System.out.print(">> ");
                        continue;
                    }
                    if (script.equals("quit")) {
                        return;
                    }
                    if (script.equals("help")) {
                        output = "history\tDisplay history\ndump\tDisplay session state\nrefresh\tClear session state\nquit\tEnd session";
                    } else if (script.equals("dump")) {
                        Bindings bindings = this.getVariables();
                        StringBuilder builder = new StringBuilder();
                        for (Map.Entry entry : bindings.entrySet()) {
                            builder.append((String)entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
                        }
                        String variables = builder.toString();
                        if (variables.isEmpty()) {
                            variables = "<empty>";
                        }
                        output = this.toString() + "\nVariables:\n" + variables;
                    } else if (script.equals("refresh")) {
                        this.getVariables().clear();
                        output = "Session refreshed";
                    } else if (script.equals("history")) {
                        output = this.getHistory();
                        if (output.isEmpty()) {
                            output = "<empty>";
                        }
                    } else {
                        output = this.run(script);
                    }
                }
                catch (Exception e) {
                    outputType = "error";
                    output = "Runtime exception: " + e.getMessage();
                    if (!isDebug) break block17;
                    e.printStackTrace();
                }
            }
            if (outputType.equals("error")) {
                if (isDebug) continue;
                output = new StringBuffer().append("ERROR: ").append(output).toString();
                System.out.print(output + "\n");
                System.out.print(">> ");
                continue;
            }
            System.out.print(output + "\n");
            System.out.print(">> ");
        }
    }

    public Bindings getVariables() {
        return this._engine.getBindings(100);
    }

    public String getHistory() {
        return this._history.toString();
    }

    public String toString() {
        ScriptEngineFactory factory = this._engine.getFactory();
        String info = "Scripting engine: " + factory.getEngineName() + " (v" + factory.getEngineVersion() + ")\n";
        info = new StringBuffer().append(info).append("Language version: ").append(factory.getLanguageName()).append(" ").append(factory.getLanguageVersion()).append("\n").toString();
        return info;
    }

    public static void main(String[] args) {
        try {
            ExoScriptingConsole console = new ExoScriptingConsole("ECMAScript");
            System.out.println(console.toString());
            console.getVariables().put("x", (Object)5);
            System.out.println("x + 1 = " + console.run("println(x+1)"));
            console.runInSystemTerminal(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

