/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.picketbox.datasource.security.GetPrincipalInfoAction;
import org.picketbox.datasource.security.SubjectActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger(CallerIdentityLoginModule.class);
    private boolean trace = log.isTraceEnabled();
    private String userName;
    private char[] password;
    private boolean addRunAsRoles;
    private Set<Principal> runAsRoles;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        String pass;
        super.initialize(subject, handler, sharedState, options);
        this.userName = (String)options.get("userName");
        if (this.userName == null) {
            log.debug((Object)"No default username supplied.");
        }
        if ((pass = (String)options.get("password")) == null) {
            log.debug((Object)"No default password supplied.");
        } else {
            this.password = pass.toCharArray();
        }
        if (pass != null && SecurityVaultUtil.isVaultFormat(pass)) {
            try {
                pass = SecurityVaultUtil.getValueAsString(pass);
            }
            catch (SecurityVaultException e) {
                throw new RuntimeException(e);
            }
            this.password = pass.toCharArray();
        }
        String flag = (String)options.get("addRunAsRoles");
        this.addRunAsRoles = Boolean.valueOf(flag);
        log.debug((Object)("got default principal: " + this.userName + ", username: " + this.userName + ", password: " + (this.password == null ? "null" : "****") + " addRunAsRoles: " + this.addRunAsRoles));
    }

    @Override
    public boolean login() throws LoginException {
        if (this.trace) {
            log.trace((Object)"Caller Association login called");
        }
        String username = this.userName;
        try {
            Principal user = GetPrincipalInfoAction.getPrincipal();
            char[] userPassword = GetPrincipalInfoAction.getCredential();
            if (userPassword != null) {
                this.password = userPassword;
                if (SecurityVaultUtil.isVaultFormat(this.password)) {
                    this.password = SecurityVaultUtil.getValue(this.password);
                }
            }
            if (user != null) {
                RunAsIdentity runAs;
                username = user.getName();
                if (this.trace) {
                    log.trace((Object)("Current Calling principal is: " + username + " ThreadName: " + Thread.currentThread().getName()));
                }
                if ((runAs = GetPrincipalInfoAction.peekRunAsIdentity()) != null) {
                    this.runAsRoles = runAs.getRunAsRoles();
                }
            }
        }
        catch (Throwable e) {
            throw new LoginException("PB00019: Processing Failed:Unable to get the calling principal or its credentials for resource association");
        }
        this.userName = username;
        if (super.login()) {
            return true;
        }
        this.sharedState.put("javax.security.auth.login.name", username);
        this.loginOk = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.sharedState.put("javax.security.auth.login.name", this.userName);
        if (this.addRunAsRoles && this.runAsRoles != null) {
            SubjectActions.addRoles(this.subject, this.runAsRoles);
        }
        PasswordCredential cred = new PasswordCredential(this.userName, this.password);
        SubjectActions.addCredentials(this.subject, cred);
        return super.commit();
    }

    @Override
    protected Principal getIdentity() {
        if (this.trace) {
            log.trace((Object)"getIdentity called");
        }
        SimplePrincipal principal = new SimplePrincipal(this.userName);
        return principal;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        if (this.trace) {
            log.trace((Object)"getRoleSets called");
        }
        return new Group[0];
    }
}

