/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormTableInputSet;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ExportActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={UncheckAllActionListener.class}), @EventConfig(listeners={CheckAllActionListener.class})})
public class UINodeTypeExport
extends UIForm {
    static final String TABLE_NAME = "UINodeTypeExport";
    static final String LABEL = "label";
    static final String INPUT = "input";
    static final String[] TABLE_COLUMNS = new String[]{"label", "input"};
    private List<NodeType> nodeTypeList_ = new ArrayList<NodeType>();

    public void update() throws Exception {
        UIFormTableInputSet uiTableInputSet = (UIFormTableInputSet)this.createUIComponent(UIFormTableInputSet.class, null, null);
        ExtendedNodeTypeManager ntManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        uiTableInputSet.setName(TABLE_NAME);
        uiTableInputSet.setColumns(TABLE_COLUMNS);
        while (nodeTypeIter.hasNext()) {
            NodeType nt = nodeTypeIter.nextNodeType();
            this.nodeTypeList_.add(nt);
            String ntName = nt.getName();
            UIFormInputSet uiInputSet = new UIFormInputSet(ntName);
            UIFormInputInfo uiInfo = new UIFormInputInfo(LABEL, null, ntName);
            uiInputSet.addChild((UIComponent)uiInfo);
            UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(ntName, ntName, null);
            uiCheckbox.setChecked(true);
            uiCheckbox.setValue((Object)ntName);
            uiInputSet.addChild((UIComponent)uiCheckbox);
            uiTableInputSet.addChild((UIComponent)uiInputSet);
        }
        this.setActions(new String[]{"Export", "Cancel", "UncheckAll"});
        this.addUIFormInput((UIFormInputSet)uiTableInputSet);
    }

    public String getLabel(String id) {
        return id;
    }

    public NodeType getNodeTypeByName(String nodeTypeName) throws Exception {
        NodeType nodeTypeSelected = null;
        for (NodeType node : this.nodeTypeList_) {
            if (!node.getName().equals(nodeTypeName)) continue;
            nodeTypeSelected = node;
            break;
        }
        return nodeTypeSelected;
    }

    public static class CheckAllActionListener
    extends EventListener<UINodeTypeExport> {
        public void execute(Event<UINodeTypeExport> event) throws Exception {
            UINodeTypeExport uiExport = (UINodeTypeExport)((Object)event.getSource());
            ArrayList listCheckbox = new ArrayList();
            uiExport.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (int i = 0; i < listCheckbox.size(); ++i) {
                ((UIFormCheckBoxInput)listCheckbox.get(i)).setChecked(true);
            }
            uiExport.setActions(new String[]{"Export", "Cancel", "UncheckAll"});
            event.getRequestContext().addUIComponentToUpdateByAjax(uiExport.getParent());
        }
    }

    public static class UncheckAllActionListener
    extends EventListener<UINodeTypeExport> {
        public void execute(Event<UINodeTypeExport> event) throws Exception {
            UINodeTypeExport uiExport = (UINodeTypeExport)((Object)event.getSource());
            ArrayList listCheckbox = new ArrayList();
            uiExport.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (int i = 0; i < listCheckbox.size(); ++i) {
                ((UIFormCheckBoxInput)listCheckbox.get(i)).setChecked(false);
            }
            uiExport.setActions(new String[]{"Export", "Cancel", "CheckAll"});
            event.getRequestContext().addUIComponentToUpdateByAjax(uiExport.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UINodeTypeExport> {
        public void execute(Event<UINodeTypeExport> event) throws Exception {
            UINodeTypeExport uiExport = (UINodeTypeExport)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiExport.getAncestorOfType(UINodeTypeManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.findComponentById("NodeTypeExportPopup");
            uiPopup.setShowMask(true);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class ExportActionListener
    extends EventListener<UINodeTypeExport> {
        public void execute(Event<UINodeTypeExport> event) throws Exception {
            UINodeTypeExport uiExport = (UINodeTypeExport)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiExport.getAncestorOfType(UINodeTypeManager.class);
            UIApplication uiApp = (UIApplication)uiExport.getAncestorOfType(UIApplication.class);
            ArrayList<NodeType> selectedNodes = new ArrayList<NodeType>();
            ArrayList listCheckbox = new ArrayList();
            uiExport.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            for (int i = 0; i < listCheckbox.size(); ++i) {
                boolean checked = ((UIFormCheckBoxInput)listCheckbox.get(i)).isChecked();
                if (!checked) continue;
                selectedNodes.add(uiExport.getNodeTypeByName(((UIFormCheckBoxInput)listCheckbox.get(i)).getName()));
            }
            if (selectedNodes.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UINodeTypeExport.msg.item-null", null));
                return;
            }
            String nodeTypeXML = this.getNodeTypeXML(selectedNodes);
            ByteArrayInputStream is = new ByteArrayInputStream(nodeTypeXML.getBytes());
            InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)is, "text/xml");
            DownloadService dservice = (DownloadService)uiExport.getApplicationComponent(DownloadService.class);
            dresource.setDownloadName("nodetype_export.xml");
            String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
            requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + downloadLink + "');");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.findComponentById("NodeTypeExportPopup");
            uiPopup.setShowMask(true);
            uiPopup.setRendered(false);
        }

        private String getNodeTypeXML(List selectedNodes) {
            StringBuilder nodeTypeXML = new StringBuilder();
            nodeTypeXML.append("<nodeTypes xmlns:nt=").append("\"");
            nodeTypeXML.append("http://www.jcp.org/jcr/nt/1.5").append("\" ");
            nodeTypeXML.append("xmlns:mix=").append("\"");
            nodeTypeXML.append("http://www.jcp.org/jcr/mix/1.5").append("\" ");
            nodeTypeXML.append("xmlns:jcr=").append("\"").append("http://www.jcp.org/jcr/1.5");
            nodeTypeXML.append("\" >").append("\n");
            for (int i = 0; i < selectedNodes.size(); ++i) {
                NodeType nodeType = (NodeType)selectedNodes.get(i);
                nodeTypeXML.append("<nodeType ");
                nodeTypeXML.append("name=").append("\"").append(nodeType.getName()).append("\" ");
                String isMixIn = String.valueOf(nodeType.isMixin());
                nodeTypeXML.append("isMixin=").append("\"").append(String.valueOf(isMixIn)).append("\" ");
                String hasOrderable = String.valueOf(nodeType.hasOrderableChildNodes());
                nodeTypeXML.append("hasOrderableChildNodes=\"").append(hasOrderable).append("\" ");
                String primaryItemName = "";
                if (nodeType.getPrimaryItemName() != null) {
                    primaryItemName = nodeType.getPrimaryItemName();
                }
                nodeTypeXML.append("primaryItemName=").append("\"").append(primaryItemName).append("\" >");
                nodeTypeXML.append("\n");
                String representSuperType = this.representSuperTypes(nodeType);
                nodeTypeXML.append(representSuperType);
                String representPropertiesXML = this.representPropertyDefinition(nodeType);
                nodeTypeXML.append(representPropertiesXML);
                String representChildXML = this.representChildNodeDefinition(nodeType);
                nodeTypeXML.append(representChildXML);
                nodeTypeXML.append("</nodeType>").append("\n");
            }
            nodeTypeXML.append("</nodeTypes>");
            return nodeTypeXML.toString();
        }

        private String representSuperTypes(NodeType nodeType) {
            StringBuilder superTypeXML = new StringBuilder();
            NodeType[] superType = nodeType.getDeclaredSupertypes();
            if (superType != null && superType.length > 0) {
                superTypeXML.append("<supertypes>").append("\n");
                for (int i = 0; i < superType.length; ++i) {
                    String typeName = superType[i].getName();
                    superTypeXML.append("<supertype>").append(typeName).append("</supertype>").append("\n");
                }
                superTypeXML.append("</supertypes>").append("\n");
            }
            return superTypeXML.toString();
        }

        private String representPropertyDefinition(NodeType nodeType) {
            String[] requireType = new String[]{"undefined", "String", "Binary", "Long", "Double", "Date", "Boolean", "Name", "Path", "Reference"};
            String[] onparentVersion = new String[]{"", "COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"};
            StringBuilder propertyXML = new StringBuilder();
            propertyXML.append("<propertyDefinitions>").append("\n");
            PropertyDefinition[] proDef = nodeType.getPropertyDefinitions();
            for (int j = 0; j < proDef.length; ++j) {
                propertyXML.append("<propertyDefinition ");
                propertyXML.append("name=").append("\"").append(proDef[j].getName()).append("\" ");
                String requiredValue = null;
                requiredValue = proDef[j].getRequiredType() == 100 ? "Permission" : requireType[proDef[j].getRequiredType()];
                propertyXML.append("requiredType=").append("\"").append(requiredValue).append("\" ");
                String autoCreate = String.valueOf(proDef[j].isAutoCreated());
                propertyXML.append("autoCreated=").append("\"").append(autoCreate).append("\" ");
                String mandatory = String.valueOf(proDef[j].isMandatory());
                propertyXML.append("mandatory=").append("\"").append(mandatory).append("\" ");
                String onVersion = onparentVersion[proDef[j].getOnParentVersion()];
                propertyXML.append("onParentVersion=").append("\"").append(onVersion).append("\" ");
                String protect = String.valueOf(proDef[j].isProtected());
                propertyXML.append("protected=").append("\"").append(protect).append("\" ");
                String multiple = String.valueOf(proDef[j].isMultiple());
                propertyXML.append("multiple=").append("\"").append(multiple).append("\" >").append("\n");
                String[] constraints = proDef[j].getValueConstraints();
                if (constraints != null && constraints.length > 0) {
                    propertyXML.append("<valueConstraints>").append("\n");
                    for (int k = 0; k < constraints.length; ++k) {
                        String cons = constraints[k].toString();
                        propertyXML.append("<valueConstraint>").append(cons).append("</valueConstraint>");
                        propertyXML.append("\n");
                    }
                    propertyXML.append("</valueConstraints>").append("\n");
                } else {
                    propertyXML.append("<valueConstraints/>").append("\n");
                }
                propertyXML.append("</propertyDefinition>").append("\n");
            }
            propertyXML.append("</propertyDefinitions>").append("\n");
            return propertyXML.toString();
        }

        private String representChildNodeDefinition(NodeType nodeType) {
            String[] onparentVersion = new String[]{"", "COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"};
            StringBuilder childNodeXML = new StringBuilder();
            NodeDefinition[] childDef = nodeType.getChildNodeDefinitions();
            if (childDef != null && childDef.length > 0) {
                childNodeXML.append("<childNodeDefinitions>").append("\n");
                for (int j = 0; j < childDef.length; ++j) {
                    childNodeXML.append("<childNodeDefinition ");
                    childNodeXML.append("name=").append("\"").append(childDef[j].getName()).append("\" ");
                    NodeType defaultType = childDef[j].getDefaultPrimaryType();
                    if (defaultType != null) {
                        String defaultName = defaultType.getName();
                        childNodeXML.append("defaultPrimaryType=").append("\"").append(defaultName).append("\" ");
                    } else {
                        childNodeXML.append("defaultPrimaryType=").append("\"").append("\" ");
                    }
                    String autoCreate = String.valueOf(childDef[j].isAutoCreated());
                    childNodeXML.append("autoCreated=").append("\"").append(autoCreate).append("\" ");
                    String mandatory = String.valueOf(childDef[j].isMandatory());
                    childNodeXML.append("mandatory=").append("\"").append(mandatory).append("\" ");
                    String onVersion = onparentVersion[childDef[j].getOnParentVersion()];
                    childNodeXML.append("onParentVersion=").append("\"").append(onVersion).append("\" ");
                    String protect = String.valueOf(childDef[j].isProtected());
                    childNodeXML.append("protected=").append("\"").append(protect).append("\" ");
                    String sameName = String.valueOf(childDef[j].allowsSameNameSiblings());
                    childNodeXML.append("sameNameSiblings=").append("\"").append(sameName).append("\" >");
                    childNodeXML.append("\n");
                    NodeType[] requiredType = childDef[j].getRequiredPrimaryTypes();
                    if (requiredType != null && requiredType.length > 0) {
                        childNodeXML.append("<requiredPrimaryTypes>").append("\n");
                        for (int k = 0; k < requiredType.length; ++k) {
                            String requiredName = requiredType[k].getName();
                            childNodeXML.append("<requiredPrimaryType>").append(requiredName);
                            childNodeXML.append("</requiredPrimaryType>").append("\n");
                        }
                        childNodeXML.append("</requiredPrimaryTypes>").append("\n");
                    }
                    childNodeXML.append("</childNodeDefinition>").append("\n");
                }
                childNodeXML.append("</childNodeDefinitions>").append("\n");
            }
            return childNodeXML.toString();
        }
    }
}

