/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.NamePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class NameValueData
extends AbstractValueData {
    protected InternalQName value;

    protected NameValueData(int orderNumber, InternalQName value) {
        super(orderNumber);
        this.value = value;
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof NameValueData) {
            return ((NameValueData)another).value.equals((Object)this.value);
        }
        return false;
    }

    protected byte[] spoolInternalValue() {
        try {
            return this.value.getAsString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    public String toString() {
        return this.value.getAsString();
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new NamePersistedValueData(orderNumber, this.value);
    }

    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    protected String getString() {
        return this.value.getAsString();
    }

    protected InternalQName getName() {
        return this.value;
    }

    protected QPath getPath() {
        QPathEntry entry = new QPathEntry(this.value, 0);
        return new QPath(new QPathEntry[]{entry});
    }
}

