/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import org.apache.commons.betwixt.schema.Element;
import org.apache.commons.betwixt.schema.GlobalComplexType;

public class GlobalElement
implements Element {
    public static final String STRING_SIMPLE_TYPE = "xsd:string";
    private String name;
    private String type;
    private GlobalComplexType complexType;

    public GlobalElement() {
    }

    public GlobalElement(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public GlobalElement(String name, GlobalComplexType complexType) {
        this.setName(name);
        this.setComplexType(complexType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public GlobalComplexType getComplexType() {
        return this.complexType;
    }

    public void setComplexType(GlobalComplexType type) {
        this.type = type.getName();
        this.complexType = type;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof GlobalElement) {
            GlobalElement element = (GlobalElement)obj;
            result = this.isEqual(this.type, element.type) && this.isEqual(this.name, element.name);
        }
        return result;
    }

    public int hashCode() {
        return 0;
    }

    private boolean isEqual(String one, String two) {
        boolean result = false;
        result = one == null ? two == null : one.equals(two);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xsd:element name='");
        buffer.append(this.name);
        buffer.append("' type='");
        buffer.append(this.type);
        buffer.append("'>");
        if (this.complexType != null) {
            buffer.append(this.complexType);
        }
        buffer.append("</xsd:element>");
        return buffer.toString();
    }
}

