/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.VisitMode;

public class GenericScope {
    private static final Tree ALL = new Tree(-1);
    private static Tree[] PREDEFINED = new Tree[]{new Tree(0), new Tree(1), new Tree(2), new Tree(3), new Tree(4), new Tree(5), new Tree(6), new Tree(7), new Tree(8), new Tree(9)};

    public static Scope branchShape(final List<String> path, Scope federated) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        return new Branch(federated){

            @Override
            protected int getSize() {
                return path.size();
            }

            @Override
            protected String getName(int index) {
                return (String)path.get(index);
            }
        };
    }

    public static Scope branchShape(final String[] path, Scope federated) {
        return new Branch(federated){

            @Override
            protected int getSize() {
                return path.length;
            }

            @Override
            protected String getName(int index) {
                return path[index];
            }
        };
    }

    public static Scope branchShape(List<String> path) {
        return GenericScope.branchShape(path, Scope.CHILDREN);
    }

    public static Scope branchShape(String[] path) {
        return GenericScope.branchShape(Arrays.asList(path), Scope.CHILDREN);
    }

    public static Scope treeShape(int height) {
        if (height < 0) {
            return ALL;
        }
        if (height < PREDEFINED.length) {
            return PREDEFINED[height];
        }
        return new Tree(height);
    }

    public static class Tree
    implements Scope {
        private final Scope.Visitor visitor;

        public Tree(final int height) {
            this.visitor = new Scope.Visitor(){

                @Override
                public VisitMode enter(int depth, String id, String name, NodeState state) {
                    if (height < 0 || depth < height) {
                        return VisitMode.ALL_CHILDREN;
                    }
                    return VisitMode.NO_CHILDREN;
                }

                @Override
                public void leave(int depth, String id, String name, NodeState state) {
                }
            };
        }

        @Override
        public Scope.Visitor get() {
            return this.visitor;
        }
    }

    public static abstract class Branch
    implements Scope {
        private final Scope federated;

        public Branch(Scope federated) throws NullPointerException {
            if (federated == null) {
                throw new NullPointerException("no null federated scope accepted");
            }
            this.federated = federated;
        }

        protected abstract int getSize();

        protected abstract String getName(int var1);

        @Override
        public Visitor get() {
            return new Visitor(){

                @Override
                protected int getSize() {
                    return Branch.this.getSize();
                }

                @Override
                protected String getName(int index) {
                    return Branch.this.getName(index);
                }

                @Override
                protected Scope.Visitor getFederated() {
                    return Branch.this.federated.get();
                }
            };
        }

        public static abstract class Visitor
        implements Scope.Visitor {
            private Scope.Visitor visitor = null;

            protected Visitor() {
            }

            protected abstract int getSize();

            protected abstract String getName(int var1);

            protected abstract Scope.Visitor getFederated();

            @Override
            public VisitMode enter(int depth, String id, String name, NodeState state) {
                int size = this.getSize();
                if (depth < size) {
                    if (depth == 0 || name.equals(this.getName(depth - 1))) {
                        return VisitMode.ALL_CHILDREN;
                    }
                    return VisitMode.NO_CHILDREN;
                }
                if (depth == size) {
                    if (depth == 0 || name.equals(this.getName(depth - 1))) {
                        Scope.Visitor visitor = this.getFederated();
                        VisitMode mode = visitor.enter(0, id, name, state);
                        if (mode == VisitMode.ALL_CHILDREN) {
                            this.visitor = visitor;
                        }
                        return mode;
                    }
                    return VisitMode.NO_CHILDREN;
                }
                return this.visitor.enter(depth - size, id, name, state);
            }

            @Override
            public void leave(int depth, String id, String name, NodeState state) {
                int size = this.getSize();
                if (depth >= size) {
                    if (depth == size) {
                        if (depth == 0 || name.equals(this.getName(depth - 1))) {
                            this.visitor.leave(0, id, name, state);
                            this.visitor = null;
                        }
                    } else {
                        this.visitor.leave(depth - size, id, name, state);
                    }
                }
            }
        }
    }
}

