/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.blocks.DistributedLockManager;
import org.jgroups.blocks.LockManager;
import org.jgroups.blocks.LockMultiLockedException;
import org.jgroups.blocks.LockNotGrantedException;
import org.jgroups.blocks.LockNotReleasedException;
import org.jgroups.blocks.VotingAdapter;
import org.jgroups.tests.ChannelTestBase;

public class DistributedLockManagerTest
extends ChannelTestBase {
    private Channel channel1;
    private Channel channel2;
    protected VotingAdapter adapter1;
    protected VotingAdapter adapter2;
    protected LockManager lockManager1;
    protected LockManager lockManager2;
    protected static boolean logConfigured;

    public DistributedLockManagerTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(DistributedLockManagerTest.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.channel1 = this.createChannel("A");
        this.adapter1 = new VotingAdapter(this.channel1);
        this.channel1.connect("voting");
        this.lockManager1 = new DistributedLockManager(this.adapter1, (Object)"1");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.channel2 = this.createChannel("A");
        this.adapter2 = new VotingAdapter(this.channel2);
        this.lockManager2 = new DistributedLockManager(this.adapter2, (Object)"2");
        this.channel2.connect("voting");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.channel2.close();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.channel1.close();
    }

    public void test() throws Exception {
        this.lockManager1.lock("obj1", "owner1", 10000);
        try {
            this.lockManager1.lock("obj1", "owner2", 10000);
            DistributedLockManagerTest.assertTrue((String)"obj1 should not be locked.", (boolean)false);
        }
        catch (LockNotGrantedException ex) {
            // empty catch block
        }
        this.lockManager2.lock("obj2", "owner2", 1000);
        this.lockManager1.unlock("obj1", "owner1");
        try {
            this.lockManager1.unlock("obj2", "owner1");
            DistributedLockManagerTest.assertTrue((String)"obj2 should not be released.", (boolean)false);
        }
        catch (LockNotReleasedException lockNotReleasedException) {
            // empty catch block
        }
        this.lockManager1.unlock("obj2", "owner2");
    }

    public void testMultiLock() throws Exception {
        this.lockManager1.lock("obj1", "owner1", 10000);
        Class<?> acquireLockDecreeClass = Class.forName("org.jgroups.blocks.DistributedLockManager$AcquireLockDecree");
        Constructor<?> acquireLockDecreeConstructor = acquireLockDecreeClass.getDeclaredConstructor(Object.class, Object.class, Object.class);
        acquireLockDecreeConstructor.setAccessible(true);
        Object acquireLockDecree = acquireLockDecreeConstructor.newInstance("obj1", "owner2", "2");
        Field heldLocksField = this.lockManager2.getClass().getDeclaredField("heldLocks");
        heldLocksField.setAccessible(true);
        HashMap heldLocks = (HashMap)heldLocksField.get(this.lockManager2);
        heldLocks.put("obj1", acquireLockDecree);
        try {
            this.lockManager1.unlock("obj1", "owner1", true);
            DistributedLockManagerTest.assertTrue((String)"obj1 should throw a lockMultiLockedException upon release.", (boolean)false);
        }
        catch (LockMultiLockedException e) {
            // empty catch block
        }
        try {
            this.lockManager1.lock("obj1", "owner1", 10000);
            DistributedLockManagerTest.assertTrue((String)"obj1 should throw a LockNotGrantedException because it is still locked by lockManager2.", (boolean)false);
        }
        catch (LockNotGrantedException e) {
            // empty catch block
        }
        try {
            this.lockManager2.unlock("obj1", "owner2", true);
            DistributedLockManagerTest.assertTrue((String)"obj1 should throw a lockMultiLockedException upon release.", (boolean)false);
        }
        catch (LockMultiLockedException e) {
            // empty catch block
        }
        try {
            this.lockManager1.lock("obj1", "owner1", 10000);
        }
        catch (LockNotGrantedException e) {
            DistributedLockManagerTest.assertTrue((String)"obj1 should be unlocked", (boolean)false);
        }
        this.lockManager1.unlock("obj1", "owner1", true);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DistributedLockManagerTest.suite());
    }
}

