/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.CalendarUpdateEventListener;
import org.exoplatform.calendar.service.DeleteShareJob;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.ImportCalendarJob;
import org.exoplatform.calendar.service.RemoteCalendar;
import org.exoplatform.calendar.service.RemoteCalendarService;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.ShareCalendarJob;
import org.exoplatform.calendar.service.SynchronizeRemoteCalendarJob;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.calendar.service.impl.CsvImportExport;
import org.exoplatform.calendar.service.impl.ICalendarImportExport;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.service.impl.RemoteCalendarServiceImpl;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.services.scheduler.impl.JobSchedulerServiceImpl;
import org.picocontainer.Startable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class CalendarServiceImpl
implements CalendarService,
Startable {
    private final AtomicBoolean isRBLoaded_ = new AtomicBoolean();
    private ResourceBundle rb_;
    private ResourceBundleService rbs_;
    private JCRDataStorage storage_;
    private Map<String, CalendarImportExport> calendarImportExport_ = new LinkedHashMap<String, CalendarImportExport>();
    protected List<CalendarUpdateEventListener> listeners_ = new ArrayList<CalendarUpdateEventListener>(3);
    protected List<CalendarEventListener> eventListeners_ = new ArrayList<CalendarEventListener>(3);
    private RemoteCalendarService remoteCalendarService;
    private static final Log LOG = ExoLogger.getExoLogger(CalendarServiceImpl.class);

    public CalendarServiceImpl(InitParams params, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService reposervice, ResourceBundleService rbs, CacheService cservice) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, reposervice, cservice);
        this.calendarImportExport_.put("ICalendar(.ics)", new ICalendarImportExport(this.storage_));
        this.calendarImportExport_.put("ExportedCsv(.csv)", new CsvImportExport(this.storage_));
        this.remoteCalendarService = new RemoteCalendarServiceImpl(this.storage_);
        this.rbs_ = rbs;
        ExoProperties props = params.getPropertiesParam("eventNumber.info").getProperties();
        String eventNumber = props.getProperty("eventNumber");
        Utils.EVENT_NUMBER = Integer.parseInt(eventNumber);
    }

    public JCRDataStorage getDataStorage() {
        return this.storage_;
    }

    @Override
    public Calendar getUserCalendar(String username, String calendarId) throws Exception {
        return this.storage_.getUserCalendar(username, calendarId);
    }

    @Override
    public List<Calendar> getUserCalendars(String username, boolean isShowAll) throws Exception {
        return this.storage_.getUserCalendars(username, isShowAll);
    }

    @Override
    public void saveUserCalendar(String username, Calendar calendar, boolean isNew) throws Exception {
        this.storage_.saveUserCalendar(username, calendar, isNew);
    }

    @Override
    public Calendar removeUserCalendar(String username, String calendarId) throws Exception {
        return this.storage_.removeUserCalendar(username, calendarId);
    }

    @Override
    public Calendar getGroupCalendar(String calendarId) throws Exception {
        return this.storage_.getGroupCalendar(calendarId);
    }

    @Override
    public List<GroupCalendarData> getGroupCalendars(String[] groupIds, boolean isShowAll, String username) throws Exception {
        return this.storage_.getGroupCalendars(groupIds, isShowAll, username);
    }

    @Override
    public void savePublicCalendar(Calendar calendar, boolean isNew) throws Exception {
        this.storage_.savePublicCalendar(calendar, isNew, null);
    }

    @Override
    public Calendar removePublicCalendar(String calendarId) throws Exception {
        return this.storage_.removeGroupCalendar(calendarId);
    }

    @Override
    public List<EventCategory> getEventCategories(String username) throws Exception {
        return this.storage_.getEventCategories(username);
    }

    @Override
    public void saveEventCategory(String username, EventCategory eventCategory, boolean isNew) throws Exception {
        EventCategory ev = this.getEventCategoryByName(username, eventCategory.getName());
        if (ev != null && (isNew || !ev.getId().equals(eventCategory.getId()))) {
            throw new ItemExistsException();
        }
        this.storage_.saveEventCategory(username, eventCategory, isNew);
    }

    public void saveEventCategory(String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        this.saveEventCategory(username, eventCategory, isNew);
    }

    @Override
    public void removeEventCategory(String username, String eventCategoryId) throws Exception {
        this.storage_.removeEventCategory(username, eventCategoryId);
    }

    @Override
    public List<CalendarEvent> getUserEventByCalendar(String username, List<String> calendarIds) throws Exception {
        return this.storage_.getUserEventByCalendar(username, calendarIds);
    }

    @Override
    public List<CalendarEvent> getUserEvents(String username, EventQuery eventQuery) throws Exception {
        return this.storage_.getUserEvents(username, eventQuery);
    }

    @Override
    public CalendarEvent getEvent(String username, String eventId) throws Exception {
        return this.storage_.getEvent(username, eventId);
    }

    @Override
    public void saveUserEvent(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveUserEvent(username, calendarId, event, isNew);
    }

    @Override
    public CalendarEvent removeUserEvent(String username, String calendarId, String eventId) throws Exception {
        return this.storage_.removeUserEvent(username, calendarId, eventId);
    }

    @Override
    public CalendarEvent getGroupEvent(String eventId) throws Exception {
        return this.storage_.getGroupEvent(eventId);
    }

    @Override
    public CalendarEvent getGroupEvent(String calendarId, String eventId) throws Exception {
        return this.storage_.getGroupEvent(calendarId, eventId);
    }

    @Override
    public List<CalendarEvent> getGroupEventByCalendar(List<String> calendarIds) throws Exception {
        return this.storage_.getGroupEventByCalendar(calendarIds);
    }

    @Override
    public List<CalendarEvent> getPublicEvents(EventQuery eventQuery) throws Exception {
        return this.storage_.getPublicEvents(eventQuery);
    }

    @Override
    public void savePublicEvent(String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        CalendarEvent oldEvent = this.getGroupEvent(event.getId());
        this.storage_.savePublicEvent(calendarId, event, isNew);
        for (CalendarEventListener cel : this.eventListeners_) {
            if (isNew) {
                cel.savePublicEvent(event, calendarId);
                this.storage_.savePublicEvent(calendarId, event, false);
                continue;
            }
            cel.updatePublicEvent(oldEvent, event, calendarId);
            this.storage_.savePublicEvent(calendarId, event, false);
        }
    }

    @Override
    public CalendarEvent removePublicEvent(String calendarId, String eventId) throws Exception {
        CalendarEvent event = this.storage_.removePublicEvent(calendarId, eventId);
        for (CalendarEventListener cel : this.eventListeners_) {
            cel.deletePublicEvent(event, calendarId);
        }
        return event;
    }

    @Override
    public CalendarImportExport getCalendarImportExports(String type) {
        return this.calendarImportExport_.get(type);
    }

    @Override
    public String[] getExportImportType() throws Exception {
        return this.calendarImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public void saveCalendarSetting(String username, CalendarSetting setting) throws Exception {
        this.storage_.saveCalendarSetting(username, setting);
    }

    @Override
    public CalendarSetting getCalendarSetting(String username) throws Exception {
        return this.storage_.getCalendarSetting(username);
    }

    @Override
    public int generateRss(String username, LinkedHashMap<String, Calendar> calendars, RssData rssData) throws Exception {
        return this.storage_.generateRss(username, calendars, rssData, this.calendarImportExport_.get("ICalendar(.ics)"));
    }

    @Override
    public List<FeedData> getFeeds(String username) throws Exception {
        return this.storage_.getFeeds(username);
    }

    @Override
    public Node getRssHome(String username) throws Exception {
        return this.storage_.getRssHome(username);
    }

    @Override
    public EventPageList searchEvent(String username, EventQuery query, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchEvent(username, query, publicCalendarIds);
    }

    @Override
    public EventCategory getEventCategory(String username, String eventCategoryId) throws Exception {
        return this.storage_.getEventCategory(username, eventCategoryId);
    }

    @Override
    public Map<Integer, String> searchHightLightEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchHightLightEvent(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void shareCalendar(String username, String calendarId, List<String> receiverUsers) throws Exception {
        this.storage_.shareCalendar(username, calendarId, receiverUsers);
    }

    @Override
    public GroupCalendarData getSharedCalendars(String username, boolean isShowAll) throws Exception {
        return this.storage_.getSharedCalendars(username, isShowAll);
    }

    @Override
    public List<CalendarEvent> getEvents(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.getEvents(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void removeSharedCalendar(String username, String calendarId) throws Exception {
        this.storage_.removeSharedCalendar(username, calendarId);
    }

    @Override
    public void removeSharedCalendarFolder(String username) throws Exception {
        this.storage_.removeSharedCalendarFolder(username);
    }

    @Override
    public void saveEventToSharedCalendar(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveEventToSharedCalendar(username, calendarId, event, isNew);
    }

    @Override
    public Map<String, String> checkFreeBusy(EventQuery eventQuery) throws Exception {
        return this.storage_.checkFreeBusy(eventQuery);
    }

    @Override
    public void saveSharedCalendar(String username, Calendar calendar) throws Exception {
        this.storage_.saveSharedCalendar(username, calendar);
    }

    @Override
    public void removeSharedEvent(String username, String calendarId, String eventId) throws Exception {
        this.storage_.removeSharedEvent(username, calendarId, eventId);
    }

    @Override
    public void moveEvent(String fromCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        HashMap<String, CalendarEvent> oldEventList = new HashMap<String, CalendarEvent>();
        if (fromType.equalsIgnoreCase(toType) && toType.equalsIgnoreCase(String.valueOf(2)) && fromCalendar.equalsIgnoreCase(toCalendar)) {
            for (CalendarEvent event : calEvents) {
                oldEventList.put(event.getId(), this.getGroupEvent(event.getId()));
            }
        }
        this.storage_.moveEvent(fromCalendar, toCalendar, fromType, toType, calEvents, username);
        if (fromType.equalsIgnoreCase(toType) && toType.equalsIgnoreCase(String.valueOf(2)) && fromCalendar.equalsIgnoreCase(toCalendar)) {
            for (CalendarEventListener cel : this.eventListeners_) {
                for (CalendarEvent event : calEvents) {
                    if (oldEventList.isEmpty() || oldEventList.get(event.getId()) == null) continue;
                    cel.updatePublicEvent((CalendarEvent)oldEventList.get(event.getId()), event, toCalendar);
                    this.storage_.savePublicEvent(toCalendar, event, false);
                }
            }
        }
        if (!fromType.equalsIgnoreCase(String.valueOf(2)) && toType.equalsIgnoreCase(String.valueOf(2))) {
            for (CalendarEventListener cel : this.eventListeners_) {
                for (CalendarEvent event : calEvents) {
                    cel.savePublicEvent(event, toCalendar);
                    this.storage_.savePublicEvent(toCalendar, event, false);
                }
            }
        }
    }

    @Override
    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) {
        this.storage_.confirmInvitation(fromUserId, toUserId, calType, calendarId, eventId, answer);
    }

    @Override
    public void confirmInvitation(String fromUserId, String confirmingEmail, String confirmingUser, int calType, String calendarId, String eventId, int answer) throws Exception {
        this.storage_.confirmInvitation(fromUserId, confirmingEmail, confirmingUser, calType, calendarId, eventId, answer);
    }

    public void start() {
        for (CalendarUpdateEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(CalendarUpdateEventListener listener) throws Exception {
        this.listeners_.add(listener);
    }

    @Override
    public int getTypeOfCalendar(String userName, String calendarId) throws Exception {
        return this.storage_.getTypeOfCalendar(userName, calendarId);
    }

    @Override
    public int generateRss(String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateRss(username, calendarIds, rssData, this.calendarImportExport_.get("ICalendar(.ics)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle getResourceBundle() throws Exception {
        if (!this.isRBLoaded_.get()) {
            AtomicBoolean atomicBoolean = this.isRBLoaded_;
            synchronized (atomicBoolean) {
                if (!this.isRBLoaded_.get()) {
                    try {
                        this.rb_ = this.rbs_.getResourceBundle("locale.portlet.calendar.CalendarPortlet", Locale.getDefault());
                    }
                    catch (MissingResourceException e) {
                        this.rb_ = null;
                    }
                    this.isRBLoaded_.set(true);
                }
            }
        }
        return this.rb_;
    }

    @Override
    public EventCategory getEventCategoryByName(String username, String eventCategoryName) throws Exception {
        ResourceBundle rb = this.getResourceBundle();
        for (EventCategory ev : this.storage_.getEventCategories(username)) {
            if (ev.getName().equalsIgnoreCase(eventCategoryName)) {
                return ev;
            }
            if (rb == null || !eventCategoryName.equalsIgnoreCase(rb.getString("UICalendarView.label." + ev.getId()))) continue;
            return ev;
        }
        return null;
    }

    @Override
    public List<CalendarEvent> getSharedEventByCalendars(String username, List<String> calendarIds) throws Exception {
        return this.storage_.getSharedEventByCalendars(username, calendarIds);
    }

    @Override
    public void removeFeedData(String username, String title) {
        this.storage_.removeFeedData(username, title);
    }

    @Override
    public void initNewUser(String userName, CalendarSetting defaultCalendarSetting_) throws Exception {
        EventCategory eventCategory = new EventCategory();
        eventCategory.setDataInit(true);
        for (int id = 0; id < NewUserListener.defaultEventCategoryIds.length; ++id) {
            if ("defaultEventCategoryIdAll".equals(id)) continue;
            eventCategory.setId(NewUserListener.defaultEventCategoryIds[id]);
            eventCategory.setName(NewUserListener.defaultEventCategoryNames[id]);
            this.saveEventCategory(userName, eventCategory, true);
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        User u = organizationService.getUserHandler().findUserByName(userName);
        String fullName = u.getFirstName();
        if (u.getLastName() != null && fullName != null) {
            fullName = fullName + " " + u.getLastName();
        }
        if (fullName == null) {
            fullName = u.getUserName();
        }
        Calendar cal = new Calendar();
        cal.setId(Utils.getDefaultCalendarId(userName));
        cal.setName(fullName);
        cal.setDataInit(true);
        cal.setCalendarOwner(userName);
        cal.setCalendarColor(Calendar.COLORS[0]);
        if (defaultCalendarSetting_ != null && defaultCalendarSetting_.getTimeZone() != null) {
            cal.setTimeZone(defaultCalendarSetting_.getTimeZone());
        }
        this.saveUserCalendar(userName, cal, true);
        if (defaultCalendarSetting_ != null) {
            this.saveCalendarSetting(userName, defaultCalendarSetting_);
        }
        Object[] groupsOfUser = organizationService.getGroupHandler().findGroupsOfUser(userName).toArray();
        ArrayList<String> groups = new ArrayList<String>();
        for (Object object : groupsOfUser) {
            String groupId = ((Group)object).getId();
            groups.add(groupId);
        }
        this.storage_.autoShareCalendar(groups, userName);
    }

    @Override
    public void addEventListenerPlugin(CalendarEventListener listener) throws Exception {
        this.eventListeners_.add(listener);
    }

    @Override
    public void assignGroupTask(String taskId, String calendarId, String assignee) throws Exception {
        this.storage_.assignGroupTask(taskId, calendarId, assignee);
    }

    @Override
    public void setGroupTaskStatus(String taskId, String calendarId, String status) throws Exception {
        this.storage_.setGroupTaskStatus(taskId, calendarId, status);
    }

    @Override
    public boolean isRemoteCalendar(String username, String calendarId) throws Exception {
        return this.storage_.isRemoteCalendar(username, calendarId);
    }

    @Override
    public boolean isValidRemoteUrl(String url, String type, String remoteUser, String remotePassword) throws Exception {
        return this.remoteCalendarService.isValidRemoteUrl(url, type, remoteUser, remotePassword);
    }

    @Override
    public Calendar updateRemoteCalendarInfo(RemoteCalendar remoteCalendar) throws Exception {
        return this.storage_.updateRemoteCalendarInfo(remoteCalendar);
    }

    @Override
    public Calendar refreshRemoteCalendar(String username, String remoteCalendarId) throws Exception {
        return this.remoteCalendarService.refreshRemoteCalendar(username, remoteCalendarId);
    }

    @Override
    public Calendar importRemoteCalendar(RemoteCalendar remoteCalendar) throws Exception {
        return this.remoteCalendarService.importRemoteCalendar(remoteCalendar);
    }

    @Override
    public RemoteCalendar getRemoteCalendar(String owner, String calendarId) throws Exception {
        return this.storage_.getRemoteCalendar(owner, calendarId);
    }

    @Override
    public RemoteCalendarService getRemoteCalendarService() throws Exception {
        return this.remoteCalendarService;
    }

    @Override
    public Calendar getRemoteCalendar(String owner, String remoteUrl, String remoteType) throws Exception {
        return this.storage_.getRemoteCalendar(owner, remoteUrl, remoteType);
    }

    @Override
    public String getCalDavResourceHref(String username, String calendarId, String eventId) throws Exception {
        Node eventNode = this.storage_.getUserCalendarHome(username).getNode(calendarId).getNode(eventId);
        try {
            return eventNode.getProperty("exo:caldavHref").getString();
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception when getting caldav resource", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getCalDavResourceEtag(String username, String calendarId, String eventId) throws Exception {
        Node eventNode = this.storage_.getUserCalendarHome(username).getNode(calendarId).getNode(eventId);
        return eventNode.getProperty("exo:caldavEtag").getString();
    }

    public void setCalDavResourceHref(String username, String calendarId, String eventId, String href) throws Exception {
        this.storage_.setCalDavResourceHref(username, calendarId, eventId, href);
    }

    public void setCalDavResourceEtag(String username, String calendarId, String eventId, String etag) throws Exception {
        this.storage_.setCalDavResourceEtag(username, calendarId, eventId, etag);
    }

    @Override
    public void loadSynchronizeRemoteCalendarJob(String username) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        JobInfo info = SynchronizeRemoteCalendarJob.getJobInfo(username);
        JobDetail job = this.findSynchronizeRemoteCalendarJob(schedulerService, username);
        if (job == null) {
            JobDataMap jobData = new JobDataMap();
            jobData.put("username", username);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            jobData.put(repositoryService.getCurrentRepository().getConfiguration().getName(), repositoryService.getCurrentRepository().getConfiguration().getName());
            PeriodInfo periodInfo = new PeriodInfo(null, null, 0, 300000L);
            schedulerService.addPeriodJob(info, periodInfo, jobData);
        }
    }

    @Override
    public void stopSynchronizeRemoteCalendarJob(String username) throws Exception {
        JobInfo info = SynchronizeRemoteCalendarJob.getJobInfo(username);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        schedulerService.removeJob(info);
        schedulerService.removeJobListener(info.getJobName());
        schedulerService.removeTriggerListener(info.getJobName());
    }

    @Override
    public JobDetail findSynchronizeRemoteCalendarJob(JobSchedulerService schedulerService, String username) throws Exception {
        List list = schedulerService.getAllJobs();
        for (JobDetail jobDetail : list) {
            if (!jobDetail.getKey().getName().equals(SynchronizeRemoteCalendarJob.getRemoteCalendarName(username))) continue;
            return jobDetail;
        }
        return null;
    }

    @Override
    public int getRemoteCalendarCount(String username) throws Exception {
        return this.storage_.getRemoteCalendarCount(username);
    }

    @Override
    public Map<String, CalendarEvent> getOccurrenceEvents(CalendarEvent recurEvent, java.util.Calendar from, java.util.Calendar to, String timezone) throws Exception {
        return this.storage_.getOccurrenceEvents(recurEvent, from, to, timezone);
    }

    @Override
    public void updateOccurrenceEvent(String fromCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        HashMap<String, CalendarEvent> oldEventList = new HashMap<String, CalendarEvent>();
        if (fromType.equalsIgnoreCase(toType) && toType.equalsIgnoreCase(String.valueOf(2)) && fromCalendar.equalsIgnoreCase(toCalendar)) {
            for (CalendarEvent event : calEvents) {
                oldEventList.put(event.getId(), this.getGroupEvent(event.getId()));
            }
        }
        this.storage_.updateOccurrenceEvent(fromCalendar, toCalendar, fromType, toType, calEvents, username);
        if (fromType.equalsIgnoreCase(toType) && toType.equalsIgnoreCase(String.valueOf(2)) && fromCalendar.equalsIgnoreCase(toCalendar)) {
            for (CalendarEventListener cel : this.eventListeners_) {
                for (CalendarEvent event : calEvents) {
                    if (oldEventList.get(event.getId()) != null) {
                        cel.updatePublicEvent((CalendarEvent)oldEventList.get(event.getId()), event, toCalendar);
                        this.storage_.savePublicEvent(toCalendar, event, false);
                        continue;
                    }
                    cel.savePublicEvent(event, toCalendar);
                    this.storage_.savePublicEvent(toCalendar, event, false);
                }
            }
        }
    }

    @Override
    public List<CalendarEvent> getOriginalRecurrenceEvents(String username, java.util.Calendar from, java.util.Calendar to, String[] publicCalendarIds) throws Exception {
        return this.storage_.getOriginalRecurrenceEvents(username, from, to, publicCalendarIds);
    }

    @Override
    public List<CalendarEvent> getExceptionEvents(String username, CalendarEvent recurEvent) throws Exception {
        return this.storage_.getExceptionEvents(username, recurEvent);
    }

    @Override
    public void removeRecurrenceSeries(String username, CalendarEvent originalEvent) throws Exception {
        this.storage_.removeRecurrenceSeries(username, originalEvent);
        if (originalEvent.getActivityId() != null) {
            for (CalendarEventListener cel : this.eventListeners_) {
                cel.deletePublicEvent(originalEvent, originalEvent.getCalendarId());
            }
        }
    }

    @Override
    public void updateRecurrenceSeries(String fromCalendar, String toCalendar, String fromType, String toType, CalendarEvent occurrence, String username) throws Exception {
        CalendarEvent oldEvent = this.getGroupEvent(occurrence.getId());
        if (oldEvent == null) {
            oldEvent = this.getEvent(username, occurrence.getId());
        }
        this.storage_.updateRecurrenceSeries(fromCalendar, toCalendar, fromType, toType, occurrence, username);
        if (toType.equalsIgnoreCase(String.valueOf(2))) {
            for (CalendarEventListener cel : this.eventListeners_) {
                if (oldEvent == null) continue;
                if (oldEvent.getActivityId() != null) {
                    occurrence.setActivityId(oldEvent.getActivityId());
                    cel.updatePublicEvent(oldEvent, occurrence, fromCalendar);
                } else {
                    cel.updatePublicEvent(occurrence, toCalendar);
                }
                this.storage_.savePublicEvent(toCalendar, occurrence, false);
            }
        }
    }

    @Override
    public CalendarEvent getSharedEvent(String username, String calendarId, String eventId) throws Exception {
        return this.storage_.getSharedEvent(username, calendarId, eventId);
    }

    @Override
    public void removeOccurrenceInstance(String username, CalendarEvent occurrence) throws Exception {
        this.storage_.removeOccurrenceInstance(username, occurrence);
        String calendarId = occurrence.getCalendarId();
        int calType = Integer.parseInt(occurrence.getCalType());
        CalendarEvent repetitiveEvent = null;
        if (calType == 0) {
            repetitiveEvent = this.storage_.getUserEvent(username, calendarId, occurrence.getId());
        } else if (calType == 2) {
            repetitiveEvent = this.storage_.getGroupEvent(calendarId, occurrence.getId());
        } else if (calType == 1) {
            repetitiveEvent = this.storage_.getSharedEvent(username, calendarId, occurrence.getId());
        }
        if (this.isEventSeriesGettingToLastItem(repetitiveEvent, username)) {
            this.removeRecurrenceSeries(username, repetitiveEvent);
            return;
        }
        if (occurrence.getActivityId() != null) {
            for (CalendarEventListener cel : this.eventListeners_) {
                cel.deletePublicEvent(occurrence, occurrence.getCalendarId());
            }
        } else {
            occurrence.setFromDateTime(repetitiveEvent.getFromDateTime());
            occurrence.setToDateTime(repetitiveEvent.getToDateTime());
            for (CalendarEventListener cel : this.eventListeners_) {
                cel.updatePublicEvent(occurrence, repetitiveEvent, repetitiveEvent.getCalendarId());
            }
        }
    }

    private boolean isEventSeriesGettingToLastItem(CalendarEvent repetitiveEvent, String username) throws Exception {
        if (repetitiveEvent.getRepeatCount() <= 0L && repetitiveEvent.getRepeatUntilDate() == null) {
            return false;
        }
        if (repetitiveEvent.getRepeatCount() <= 0L && repetitiveEvent.getRepeatUntilDate() != null) {
            CalendarSetting calendarSetting = this.getCalendarSetting(username);
            TimeZone timezone = TimeZone.getTimeZone(calendarSetting.getTimeZone());
            java.util.Calendar fromDate = java.util.Calendar.getInstance(timezone);
            fromDate.setTime(repetitiveEvent.getFromDateTime());
            java.util.Calendar toDate = java.util.Calendar.getInstance(timezone);
            toDate.setTime(repetitiveEvent.getRepeatUntilDate());
            Map<String, CalendarEvent> occurrenceEvents = this.getOccurrenceEvents(repetitiveEvent, fromDate, toDate, calendarSetting.getTimeZone());
            return occurrenceEvents.keySet().size() == 0;
        }
        int numberOfOccurrences = (int)repetitiveEvent.getRepeatCount();
        return repetitiveEvent.getExcludeId().length == numberOfOccurrences;
    }

    @Override
    public Map<Integer, String> searchHighlightRecurrenceEvent(String username, EventQuery eventQuery, String[] publicCalendarIds, String timezone) throws Exception {
        return this.storage_.searchHighlightRecurrenceEvent(username, eventQuery, publicCalendarIds, timezone);
    }

    @Override
    public void shareCalendarByRunJob(String username, String calendarId, List<String> sharedGroups) throws Exception {
        JobSchedulerServiceImpl schedulerService = (JobSchedulerServiceImpl)ExoContainerContext.getCurrentContainer().getComponentInstance(JobSchedulerService.class);
        JobInfo jobInfo = new JobInfo(sharedGroups.toString(), "CS-ShareCalenar", ShareCalendarJob.class);
        ArrayList<String> newSharedGroups = new ArrayList<String>();
        for (String group : sharedGroups) {
            if (this.isGroupBeingShared(group, schedulerService)) continue;
            newSharedGroups.add(group);
        }
        if (newSharedGroups.size() > 0) {
            JobDetailImpl job = new JobDetailImpl();
            job.setName(jobInfo.getJobName());
            job.setGroup(jobInfo.getGroupName());
            job.setJobClass(jobInfo.getJob());
            job.setDescription(jobInfo.getDescription());
            job.getJobDataMap().put("sharedGroups", newSharedGroups);
            job.getJobDataMap().put("userName", username);
            job.getJobDataMap().put("calendarId", calendarId);
            SimpleTriggerImpl trigger = new SimpleTriggerImpl();
            trigger.setName(jobInfo.getJobName());
            trigger.setGroup(jobInfo.getGroupName());
            trigger.setStartTime(new Date());
            schedulerService.addJob((JobDetail)job, (Trigger)trigger);
        }
    }

    @Override
    public void removeSharedCalendarByJob(String username, List<String> unsharedGroups, String calendarId) throws Exception {
        JobSchedulerServiceImpl schedulerService_ = (JobSchedulerServiceImpl)ExoContainerContext.getCurrentContainer().getComponentInstance(JobSchedulerService.class);
        JobInfo jobInfo = new JobInfo(unsharedGroups.toString(), "CS-DeleteShare", DeleteShareJob.class);
        JobDetailImpl job = new JobDetailImpl();
        job.setName(jobInfo.getJobName());
        job.setGroup(jobInfo.getGroupName());
        job.setJobClass(jobInfo.getJob());
        job.setDescription(jobInfo.getDescription());
        job.getJobDataMap().put("userName", username);
        job.getJobDataMap().put("removedUsers", unsharedGroups);
        job.getJobDataMap().put("calendarId", calendarId);
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setName(jobInfo.getJobName());
        trigger.setGroup(jobInfo.getGroupName());
        trigger.setStartTime(new Date());
        schedulerService_.addJob((JobDetail)job, (Trigger)trigger);
    }

    @Override
    public boolean isGroupBeingShared(String group, JobSchedulerServiceImpl schedulerService_) throws Exception {
        List list = schedulerService_.getAllExcutingJobs();
        for (Object obj : list) {
            JobExecutionContext job = (JobExecutionContext)obj;
            JobDataMap jobDataMap = job.getJobDetail().getJobDataMap();
            List sharedGroups = (List)jobDataMap.get((Object)"sharedGroups");
            if (sharedGroups == null || !sharedGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CalendarEvent getEventById(String eventId) throws Exception {
        return this.storage_.getEventById(eventId);
    }

    @Override
    public Calendar getCalendarById(String calId) throws Exception {
        return this.storage_.getCalendarById(calId);
    }

    @Override
    public void autoShareCalendar(List<String> groupsOfUser, String receiver) throws Exception {
        this.storage_.autoShareCalendar(groupsOfUser, receiver);
    }

    @Override
    public void autoRemoveShareCalendar(String groupId, String username) throws Exception {
        this.storage_.autoRemoveShareCalendar(groupId, username);
    }

    @Override
    public void importRemoteCalendarByJob(RemoteCalendar remoteCalendar) throws Exception {
        JobSchedulerServiceImpl schedulerService = (JobSchedulerServiceImpl)ExoContainerContext.getCurrentContainer().getComponentInstance(JobSchedulerService.class);
        JobDetail job = ImportCalendarJob.getImportRemoteCalendarJobDetail(remoteCalendar);
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setName(remoteCalendar.getCalendarName());
        trigger.setGroup("import_calendar_job_group");
        trigger.setStartTime(new Date());
        schedulerService.addJob(job, (Trigger)trigger);
    }
}

