/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.handler.config.Handler;
import org.picketlink.identity.federation.core.handler.config.Handlers;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.util.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static Set<SAML2Handler> getHandlers(Handlers handlers) throws ConfigurationException {
        if (handlers == null) {
            throw logger.nullArgumentError("handlers");
        }
        List<Handler> handlerList = handlers.getHandler();
        LinkedHashSet<SAML2Handler> handlerSet = new LinkedHashSet<SAML2Handler>();
        for (Handler handler : handlerList) {
            String clazzName = handler.getClazz();
            try {
                Class<?> clazz = SecurityActions.loadClass(HandlerUtil.class, clazzName);
                if (clazz == null) {
                    throw new RuntimeException(logger.classNotLoadedError(clazzName));
                }
                SAML2Handler samlhandler = (SAML2Handler)clazz.newInstance();
                List<KeyValueType> options = handler.getOption();
                HashMap<String, Object> mapOptions = new HashMap<String, Object>();
                for (KeyValueType kvtype : options) {
                    mapOptions.put(kvtype.getKey(), kvtype.getValue());
                }
                DefaultSAML2HandlerConfig handlerConfig = new DefaultSAML2HandlerConfig();
                handlerConfig.set(mapOptions);
                samlhandler.initHandlerConfig(handlerConfig);
                handlerSet.add(samlhandler);
            }
            catch (InstantiationException e) {
                throw logger.configurationError(e);
            }
            catch (IllegalAccessException e) {
                throw logger.configurationError(e);
            }
        }
        return handlerSet;
    }
}

