/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

public final class UriUtils {
    public static final String CHARSET = "charset";
    private static final Logger LOG = Logger.getLogger(UriUtils.class.getName());

    private UriUtils() {
    }

    public static boolean isValidHeaderName(String name) {
        char[] dst = new char[name.length()];
        name.getChars(0, name.length(), dst, 0);
        for (char c : dst) {
            if (c < '!' || c > '~') {
                return false;
            }
            if (c != ':') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidHeaderValue(String val) {
        char[] dst = new char[val.length()];
        val.getChars(0, val.length(), dst, 0);
        for (char c : dst) {
            if (c == '\r' || c == '\n') {
                return false;
            }
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static void copyResponseHeadersAndStatusCode(HttpResponse data, HttpResponseBuilder resp, boolean remapInternalServerError, boolean setHeaders, DisallowedHeaders ... disallowedResponseHeaders) throws IOException {
        resp.setHttpStatusCode(data.getHttpStatusCode());
        HashSet<String> allDisallowedHeaders = new HashSet<String>();
        for (DisallowedHeaders h : disallowedResponseHeaders) {
            allDisallowedHeaders.addAll(h.getDisallowedHeaders());
        }
        for (Map.Entry entry : data.getHeaders().entries()) {
            if (!UriUtils.isValidHeaderName((String)entry.getKey()) || !UriUtils.isValidHeaderValue((String)entry.getValue()) || allDisallowedHeaders.contains(((String)entry.getKey()).toLowerCase())) continue;
            try {
                if (setHeaders) {
                    resp.setHeader((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                resp.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            catch (IllegalArgumentException e) {
                LOG.warning("Skipping illegal header:  " + (String)entry.getKey() + ":" + (String)entry.getValue());
            }
        }
        if (remapInternalServerError && data.getHttpStatusCode() == 500) {
            resp.setHttpStatusCode(502);
        }
    }

    public static void copyRequestHeaders(HttpRequest origRequest, HttpRequest req, DisallowedHeaders ... disallowedRequestHeaders) {
        HashSet<String> allDisallowedHeaders = new HashSet<String>();
        for (DisallowedHeaders h : disallowedRequestHeaders) {
            allDisallowedHeaders.addAll(h.getDisallowedHeaders());
        }
        for (Map.Entry<String, List<String>> inHeader : origRequest.getHeaders().entrySet()) {
            String header = inHeader.getKey();
            List<String> headerValues = inHeader.getValue();
            if (headerValues == null || headerValues.size() <= 0 || !UriUtils.isValidHeaderName(header) || allDisallowedHeaders.contains(header.toLowerCase())) continue;
            req.removeHeader(header);
            for (String headerVal : headerValues) {
                if (!UriUtils.isValidHeaderValue(headerVal)) continue;
                req.addHeader(header, headerVal);
            }
        }
    }

    public static void copyRequestData(HttpRequest origRequest, HttpRequest req) throws GadgetException {
        req.setMethod(origRequest.getMethod());
        try {
            if (origRequest.getMethod().equalsIgnoreCase("post")) {
                req.setPostBody(origRequest.getPostBody());
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public static void maybeRewriteContentType(HttpRequest req, HttpResponseBuilder response) {
        String responseType = response.getHeader("Content-Type");
        String requiredType = req.getRewriteMimeType();
        if (!StringUtils.isEmpty((String)requiredType)) {
            if (requiredType.endsWith("/*") && !StringUtils.isEmpty((String)responseType)) {
                String requiredTypePrefix = requiredType.substring(0, requiredType.length() - 1);
                if (!responseType.toLowerCase().startsWith(requiredTypePrefix.toLowerCase())) {
                    response.setHeader("Content-Type", requiredType);
                }
            } else {
                response.setHeader("Content-Type", requiredType);
            }
        }
    }

    public static String getContentTypeWithoutCharset(String content) {
        String contentTypeWithoutCharset = content;
        String[] parts = StringUtils.split((String)content, (char)';');
        if (parts.length >= 2) {
            StringBuilder contentTypeWithoutCharsetBuilder = new StringBuilder(parts.length);
            contentTypeWithoutCharsetBuilder.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String parameterAndValue = parts[i].trim().toLowerCase();
                String[] splits = StringUtils.split((String)parameterAndValue, (char)'=');
                if (splits.length <= 0 || splits[0].trim().equals(CHARSET)) continue;
                contentTypeWithoutCharsetBuilder.append(';').append(parts[i]);
            }
            contentTypeWithoutCharset = contentTypeWithoutCharsetBuilder.toString();
        }
        return contentTypeWithoutCharset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisallowedHeaders {
        OUTPUT_TRANSFER_DIRECTIVES((Set<String>)ImmutableSet.of((Object)"content-length", (Object)"transfer-encoding", (Object)"content-encoding", (Object)"server", (Object)"accept-ranges")),
        CACHING_DIRECTIVES((Set<String>)ImmutableSet.of((Object)"vary", (Object)"expires", (Object)"date", (Object)"pragma", (Object)"cache-control", (Object)"etag", (Object[])new String[]{"last-modified"})),
        CLIENT_STATE_DIRECTIVES((Set<String>)ImmutableSet.of((Object)"set-cookie", (Object)"www-authenticate")),
        POST_INCOMPATIBLE_DIRECTIVES((Set<String>)ImmutableSet.of((Object)"content-length"));

        private Set<String> disallowedHeaders;

        private DisallowedHeaders(Set<String> disallowedHeaders) {
            this.disallowedHeaders = disallowedHeaders;
        }

        public Set<String> getDisallowedHeaders() {
            return this.disallowedHeaders;
        }
    }
}

