/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import javax.transaction.Transaction;
import org.infinispan.context.AbstractInvocationContextContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;

public class NonTransactionalInvocationContextContainer
extends AbstractInvocationContextContainer {
    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        if (keyCount == 1) {
            SingleKeyNonTxInvocationContext result = new SingleKeyNonTxInvocationContext(true);
            this.ctxHolder.set(result);
            return result;
        }
        if (keyCount > 0) {
            NonTxInvocationContext ctx = new NonTxInvocationContext(keyCount, true);
            this.ctxHolder.set(ctx);
            return ctx;
        }
        return this.createInvocationContext(null);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx) {
        return this.createNonTxInvocationContext();
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        NonTxInvocationContext ctx = new NonTxInvocationContext();
        ctx.setOriginLocal(true);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        SingleKeyNonTxInvocationContext result = new SingleKeyNonTxInvocationContext(true);
        this.ctxHolder.set(result);
        return result;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        NonTxInvocationContext ctx = new NonTxInvocationContext();
        ctx.setOrigin(origin);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    public InvocationContext getInvocationContext() {
        InvocationContext invocationContext = (InvocationContext)this.ctxHolder.get();
        if (invocationContext == null) {
            throw new IllegalStateException("This method can only be called after associating the current thread with a context");
        }
        return invocationContext;
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext() {
        throw this.exception();
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        throw this.exception();
    }

    private IllegalStateException exception() {
        return new IllegalStateException("This is a non-transactional cache - why need to build a transactional context for it!");
    }
}

