/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.EmptyConstructorNamedCacheFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.ReplicationQueueImpl;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={ReplicationQueue.class})
public class ReplicationQueueFactory
extends EmptyConstructorNamedCacheFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.configuration.getCacheMode().isSynchronous() && this.configuration.isUseReplQueue()) {
            String type = this.configuration.getReplQueueClass();
            if (type == null || type.equals(ReplicationQueueImpl.class.getName())) {
                return componentType.cast(new ReplicationQueueImpl());
            }
            try {
                return componentType.cast(Util.loadClass(type, this.configuration.getClassLoader()).newInstance());
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        return null;
    }
}

