/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

class CMap
extends Dictionary
implements org.icepdf.core.pobjects.fonts.CMap {
    private static final Logger logger = Logger.getLogger(CMap.class.toString());
    private Map cIdSystemInfo;
    private String cMapName;
    private float cMapType;
    private Object useCMap;
    private int wMode;
    private int[][] codeSpaceRange;
    private boolean oneByte;
    private Map<Integer, char[]> bfChars;
    private List<CMapRange> bfRange;
    private Map cIdChars;
    private Map cIdRange;
    private Hashtable notDefChars;
    private Hashtable notDefRange;
    private Stream cMapStream;
    private InputStream cMapInputStream;

    public CMap(Library library, Hashtable entries, Stream cMapStream) {
        super(library, entries);
        this.cMapStream = cMapStream;
    }

    public CMap(Library l, Hashtable h, InputStream cMapInputStream) {
        super(l, h);
        this.cMapInputStream = cMapInputStream;
    }

    public boolean isOneByte(int cid) {
        return this.oneByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            Object token;
            if (this.cMapInputStream == null) {
                this.cMapInputStream = this.cMapStream.getInputStreamForDecodedStreamBytes();
            }
            if (logger.isLoggable(Level.FINER)) {
                String content;
                if (this.cMapInputStream instanceof SeekableInput) {
                    content = Utils.getContentFromSeekableInput((SeekableInput)((Object)this.cMapInputStream), false);
                } else {
                    InputStream[] inArray = new InputStream[]{this.cMapInputStream};
                    content = Utils.getContentAndReplaceInputStream(inArray, false);
                    this.cMapInputStream = inArray[0];
                }
                logger.finer("<------------------------ CMap");
                logger.finer(content);
                logger.finer("CMap ------------------------>  ");
            }
            Parser parser = new Parser(this.cMapInputStream);
            Object previousToken = null;
            while ((token = parser.getStreamObject()) != null) {
                String nameString = token.toString();
                if (nameString.toLowerCase().indexOf("cidsysteminfo") >= 0 && (token = parser.getStreamObject()) instanceof Hashtable) {
                    this.cIdSystemInfo = (Hashtable)token;
                    token = parser.getStreamObject();
                }
                if (token instanceof Name) {
                    nameString = token.toString();
                    if (nameString.toLowerCase().indexOf("cmapname") >= 0) {
                        token = parser.getStreamObject();
                        this.cMapName = token.toString();
                        token = parser.getStreamObject();
                    }
                    if (nameString.toLowerCase().indexOf("cmaptype") >= 0) {
                        token = parser.getStreamObject();
                        this.cMapType = Float.parseFloat(token.toString());
                        token = parser.getStreamObject();
                    }
                    if (nameString.toLowerCase().indexOf("usemap") >= 0) {
                        // empty if block
                    }
                }
                if (token instanceof String) {
                    StringObject hexToken;
                    int i;
                    String stringToken = (String)token;
                    if (stringToken.equalsIgnoreCase("begincodespacerange")) {
                        int numberOfRanges = (int)Float.parseFloat(previousToken.toString());
                        this.codeSpaceRange = new int[numberOfRanges][2];
                        for (i = 0; i < numberOfRanges; ++i) {
                            token = parser.getStreamObject();
                            hexToken = (StringObject)token;
                            int startRange = hexToken.getUnsignedInt(0, hexToken.getLength());
                            token = parser.getStreamObject();
                            hexToken = (StringObject)token;
                            int length = hexToken.getLength();
                            int endRange = hexToken.getUnsignedInt(0, length);
                            this.codeSpaceRange[i][0] = startRange;
                            this.codeSpaceRange[i][1] = endRange;
                            if (length != 2) continue;
                            this.oneByte = true;
                        }
                    }
                    if (stringToken.equalsIgnoreCase("beginbfchar")) {
                        int numberOfbfChar = (int)Float.parseFloat(previousToken.toString());
                        if (this.bfChars == null) {
                            this.bfChars = new HashMap<Integer, char[]>(numberOfbfChar);
                        }
                        for (i = 0; i < numberOfbfChar; ++i) {
                            token = parser.getStreamObject();
                            hexToken = (StringObject)token;
                            Integer key = hexToken.getUnsignedInt(0, hexToken.getLength());
                            token = parser.getStreamObject();
                            hexToken = (StringObject)token;
                            char[] value = null;
                            try {
                                value = this.convertToString(hexToken.getLiteralStringBuffer());
                            }
                            catch (NumberFormatException e) {
                                logger.log(Level.FINE, "CMAP: ", e);
                            }
                            this.bfChars.put(key, value);
                        }
                    }
                    if (stringToken.equalsIgnoreCase("beginbfrange")) {
                        int numberOfbfRanges = (int)Float.parseFloat(previousToken.toString());
                        if (this.bfRange == null) {
                            this.bfRange = new ArrayList<CMapRange>(numberOfbfRanges);
                        }
                        for (int i2 = 0; i2 < numberOfbfRanges && (token = parser.getStreamObject()) instanceof StringObject; ++i2) {
                            StringObject hexToken2 = (StringObject)token;
                            Integer startRange = hexToken2.getUnsignedInt(0, hexToken2.getLength());
                            token = parser.getStreamObject();
                            if (!(token instanceof StringObject)) break;
                            hexToken2 = (StringObject)token;
                            Integer endRange = hexToken2.getUnsignedInt(0, hexToken2.getLength());
                            token = parser.getStreamObject();
                            if (token instanceof Vector) {
                                this.bfRange.add(new CMapRange((int)startRange, (int)endRange, (Vector)token));
                                continue;
                            }
                            hexToken2 = (StringObject)token;
                            Integer offset = hexToken2.getUnsignedInt(0, hexToken2.getLength());
                            this.bfRange.add(new CMapRange((int)startRange, (int)endRange, offset));
                        }
                    }
                    if (stringToken.equalsIgnoreCase("begincidchar")) {
                        // empty if block
                    }
                    if (stringToken.equalsIgnoreCase("begincidrange")) {
                        // empty if block
                    }
                    if (stringToken.equalsIgnoreCase("beginnotdefchar")) {
                        // empty if block
                    }
                    if (stringToken.equalsIgnoreCase("beginnotdefrange")) {
                        // empty if block
                    }
                }
                previousToken = token;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "CMap parsing error", e);
        }
        catch (IOException e) {
        }
        finally {
            if (this.cMapInputStream != null) {
                try {
                    this.cMapInputStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Error clossing cmap stream", e);
                }
            }
        }
    }

    public String toUnicode(char ch) {
        char[] tmp;
        if (this.bfChars != null && (tmp = this.bfChars.get(ch)) != null) {
            return String.valueOf(tmp);
        }
        if (this.bfRange != null) {
            for (CMapRange aBfRange : this.bfRange) {
                if (!aBfRange.inRange(ch)) continue;
                return String.valueOf(aBfRange.getCMapValue(ch));
            }
        }
        return String.valueOf(ch);
    }

    public char toSelector(char charMap) {
        char[] tmp;
        if (this.bfChars != null && (tmp = this.bfChars.get(charMap)) != null) {
            return tmp[0];
        }
        if (this.bfRange != null) {
            for (CMapRange aBfRange : this.bfRange) {
                if (!aBfRange.inRange(charMap)) continue;
                return aBfRange.getCMapValue(charMap)[0];
            }
        }
        return charMap;
    }

    public char toSelector(char charMap, boolean isCFF) {
        return this.toSelector(charMap);
    }

    private char[] convertToString(CharSequence s) {
        if (s == null && s.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        int len = s.length();
        char[] dest = new char[len / 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            dest[j] = (char)(s.charAt(i) << 8 | s.charAt(i + 1));
            i += 2;
            ++j;
        }
        return dest;
    }

    class CMapRange {
        int startRange = 0;
        int endRange = 0;
        int offsetValue = 0;
        Vector offsetVecor = null;

        public CMapRange(int startRange, int endRange, int offsetValue) {
            this.startRange = startRange;
            this.endRange = endRange;
            this.offsetValue = offsetValue;
        }

        public CMapRange(int startRange, int endRange, Vector offsetVecor) {
            this.startRange = startRange;
            this.endRange = endRange;
            this.offsetVecor = offsetVecor;
        }

        public boolean inRange(int value) {
            return value >= this.startRange && value <= this.endRange;
        }

        public char[] getCMapValue(int value) {
            if (this.offsetVecor == null) {
                return new char[]{(char)(this.offsetValue + (value - this.startRange))};
            }
            StringObject hexToken = (StringObject)this.offsetVecor.elementAt(value - this.startRange);
            char[] test = CMap.this.convertToString(hexToken.getLiteralStringBuffer());
            return test;
        }
    }
}

